set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '330',
      '12',
      23.565230,
      11,
      '0011131',
      37,
      0,
      1.644936,
      3,
      '421210',
      4,
      ' 4- 0-1979',
      20.201998,
      65.768478,
      1,
      NULL,
      16.863441,
      1.098238,
      1,
      1.002965,
      0.555171,
      1,
      NULL,
      0,
      2,
      0.912120,
      6.449476,
      1,
      1,
      NULL,
      1,
      NULL,
      2,
      3.248064,
      4,
      0,
      7.091476,
      NULL,
      0,
      1,
      4,
      0,
      NULL,
      1.309899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1,
      0,
      2.435617,
      3.926757,
      NULL,
      0,
      2,
      2.679560,
      3.414492,
      NULL,
      0.096633,
      0,
      1.009983,
      NULL,
      0,
      2,
      0.119045,
      0,
      0.839459,
      0,
      4,
      2,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.541405,
      1,
      0.479732,
      2.885769,
      7,
      1,
      NULL,
      1.460216,
      NULL,
      1,
      NULL,
      0,
      0,
      1.843998,
      2,
      0,
      0,
      0,
      0,
      0,
      6.984246,
      1.220705,
      0.869293,
      NULL,
      NULL,
      0.565606,
      4.860211,
      0,
      6,
      1.737666,
      8,
      NULL,
      NULL,
      4.213685,
      5.751356,
      1.089009,
      NULL,
      NULL,
      3.569438,
      2,
      8,
      6.888425,
      0,
      9,
      6,
      7,
      11.013559,
      7,
      NULL,
      0.379178,
      1.900706,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.948712,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.113602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.209106,
      1.642006,
      0,
      NULL,
      NULL,
      NULL,
      1.801246,
      1.889762,
      3,
      0,
      4.832089,
      NULL,
      1.326085,
      NULL,
      NULL,
      NULL,
      NULL,
      4.581749,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076172,
      1,
      0,
      0,
      0,
      1.673489,
      1.933016,
      2,
      NULL,
      NULL,
      NULL,
      1.468888,
      NULL,
      0.179598,
      0.752838,
      0.310349,
      0,
      0.042551,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.754449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '12430',
      '12242',
      '',
      1.693844,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


