set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      29.320306,
      10,
      '0241143',
      153,
      NULL,
      0,
      NULL,
      NULL,
      0.707324,
      ' 1- 6-1987',
      40.400051,
      53.354796,
      0.963233,
      NULL,
      5.318125,
      0.011916,
      1.750091,
      0.619845,
      1,
      NULL,
      0.926865,
      NULL,
      2,
      0.538615,
      5.246555,
      1.222516,
      NULL,
      NULL,
      0.324149,
      2.037421,
      0.010516,
      1,
      3.261187,
      3,
      3.319057,
      2,
      1.251357,
      0,
      5.050664,
      3,
      1.767680,
      NULL,
      NULL,
      NULL,
      1.355510,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.605218,
      0,
      0,
      2.686639,
      3.957510,
      1.935212,
      3.567241,
      0,
      0.158490,
      1,
      1,
      1.167245,
      2.504612,
      NULL,
      0.149271,
      1,
      1.284072,
      1,
      0,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      1.072362,
      NULL,
      NULL,
      NULL,
      6,
      1.692804,
      2.556931,
      1,
      0.479471,
      NULL,
      1,
      0.374110,
      1,
      1.875681,
      0,
      0,
      1,
      1.546501,
      1.235979,
      0,
      1.253121,
      0,
      NULL,
      0.725431,
      6.616453,
      1.217439,
      1.397541,
      NULL,
      NULL,
      6.194038,
      0,
      1.342126,
      1,
      NULL,
      1.539251,
      NULL,
      1.438692,
      9,
      0.141228,
      6,
      7,
      4,
      7,
      6,
      NULL,
      8.424476,
      9.763596,
      9.939382,
      NULL,
      1,
      NULL,
      3,
      1.486318,
      1.846960,
      NULL,
      0.654090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626028,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      2.848941,
      NULL,
      0,
      0,
      3,
      1.181229,
      3.855985,
      5.777430,
      0.539971,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.959877,
      7,
      2,
      0.891169,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863692,
      7.354156,
      1.131075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812013,
      2,
      1.697630,
      1.255236,
      3.404207,
      2,
      1.906739,
      3.220786,
      3,
      1,
      1.029621,
      1,
      1,
      NULL,
      1,
      0,
      0,
      1.449621,
      NULL,
      1.275949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.872070,
      NULL,
      '12433',
      '',
      0.832702,
      '',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      0.839313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


