set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '013',
      NULL,
      24,
      17.650688,
      '0302000',
      93,
      0,
      1.638977,
      0,
      '221010',
      5.862781,
      ' 2-14-1987',
      54,
      60.165870,
      0,
      NULL,
      NULL,
      1,
      3.656265,
      0,
      NULL,
      1,
      0.315875,
      1.901621,
      2.642045,
      1.389931,
      1.647064,
      0,
      1.628250,
      2.318023,
      0.480135,
      3.283228,
      NULL,
      1.981503,
      4,
      7,
      NULL,
      3.869329,
      9,
      NULL,
      3,
      5,
      3.607724,
      1.346439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0.637050,
      NULL,
      2,
      0,
      0.279469,
      3,
      0.440083,
      0,
      NULL,
      1,
      0.766510,
      0.340060,
      0.566296,
      0,
      NULL,
      3.260416,
      0.492894,
      0.696914,
      NULL,
      3.520003,
      4,
      NULL,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.602681,
      NULL,
      NULL,
      0.558450,
      2,
      1.660191,
      3.420672,
      6,
      1,
      1,
      0.679982,
      1.956039,
      NULL,
      1,
      0,
      1.205726,
      0,
      0.412412,
      0.611491,
      0.033225,
      1.815041,
      0,
      NULL,
      0.332002,
      5.038387,
      0,
      0.322481,
      NULL,
      3.010993,
      0.941770,
      1.914646,
      2.859185,
      NULL,
      8.847646,
      3.953128,
      10,
      NULL,
      5.182312,
      NULL,
      3.951393,
      7,
      4,
      4.478993,
      4.194470,
      9.430245,
      NULL,
      0.479360,
      NULL,
      4.210443,
      5.872984,
      0,
      1,
      NULL,
      1.940996,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      NULL,
      1.007269,
      0.825917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.628496,
      NULL,
      0,
      1,
      0,
      0.386134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.958910,
      2,
      1.110483,
      NULL,
      NULL,
      NULL,
      5.905782,
      5.679994,
      9.901537,
      5,
      NULL,
      0,
      1,
      1.928313,
      NULL,
      NULL,
      NULL,
      6.980130,
      1.705213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.898854,
      2,
      0,
      0,
      3.650860,
      3.777603,
      1,
      2,
      NULL,
      1.468255,
      NULL,
      1.732103,
      0,
      NULL,
      0,
      0,
      1.611899,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '20304',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


