set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21',
      28,
      2.288030,
      '2110210',
      NULL,
      4,
      1.824428,
      NULL,
      '220304',
      5,
      '10-26-1988',
      NULL,
      28,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.680624,
      NULL,
      0.833669,
      1,
      NULL,
      2,
      1.842643,
      7,
      0,
      0,
      2,
      NULL,
      5,
      NULL,
      1.867593,
      4,
      2.027557,
      NULL,
      3,
      3.855243,
      NULL,
      NULL,
      0.803628,
      NULL,
      1.054794,
      NULL,
      NULL,
      0.392664,
      NULL,
      NULL,
      3,
      0,
      1.870915,
      NULL,
      1,
      0.679739,
      0.306642,
      NULL,
      0,
      2,
      NULL,
      2,
      1,
      0.447427,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.710585,
      0,
      2,
      1,
      0,
      NULL,
      0,
      0.178943,
      NULL,
      NULL,
      0.669958,
      NULL,
      NULL,
      1.301692,
      5.782129,
      1.497333,
      4,
      NULL,
      0.886229,
      1.418692,
      0,
      1.245999,
      1.714454,
      1.690876,
      NULL,
      1.634023,
      0.744261,
      1.524057,
      0.170343,
      0.804724,
      1,
      1,
      NULL,
      0,
      NULL,
      0.742705,
      0,
      7,
      5.223673,
      1.544976,
      1.888295,
      0.002433,
      7.664288,
      8.217834,
      0,
      9,
      3,
      NULL,
      0,
      1.176754,
      3.682856,
      4.292933,
      6.552597,
      NULL,
      8.903532,
      2,
      2.065037,
      9.241357,
      4,
      NULL,
      3.573123,
      3,
      0,
      0.580569,
      4,
      1.639629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.942138,
      2,
      NULL,
      1,
      1,
      NULL,
      1.022765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      4,
      1.152904,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.011109,
      0,
      NULL,
      NULL,
      NULL,
      4,
      7,
      3.191530,
      4.033495,
      4,
      0,
      5.739006,
      1.655916,
      NULL,
      NULL,
      1.382829,
      10.416073,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.557061,
      NULL,
      0.737164,
      3.192348,
      3.199955,
      NULL,
      3.637045,
      3,
      1.130953,
      1.526457,
      0.346176,
      1.743162,
      1,
      0.945002,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      1.346782,
      '',
      NULL,
      '',
      0.615716,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


