set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '321',
      NULL,
      33,
      0.995470,
      '2131010',
      NULL,
      NULL,
      3,
      3,
      '413414',
      4,
      '10-17-1996',
      51.775688,
      13,
      1.459493,
      NULL,
      18,
      1,
      3.136633,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.959852,
      1,
      0,
      1.578844,
      0,
      5.739985,
      5,
      0,
      3,
      NULL,
      2,
      NULL,
      2.790062,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.817691,
      5.060182,
      2.156838,
      1.954896,
      1,
      2,
      0,
      NULL,
      NULL,
      1.186899,
      0.418194,
      NULL,
      2.061252,
      1,
      NULL,
      1,
      1.901189,
      0,
      0,
      1,
      0,
      0.474823,
      1.523728,
      3.430304,
      4.789609,
      0,
      1,
      1.785079,
      0,
      NULL,
      NULL,
      1.758948,
      0,
      1,
      1,
      3.878471,
      NULL,
      4.634541,
      NULL,
      0.489603,
      NULL,
      NULL,
      0.220225,
      1.227751,
      1,
      0,
      NULL,
      1,
      1,
      1.720981,
      1,
      0,
      1,
      NULL,
      1,
      6.314897,
      1.301528,
      1.149550,
      7,
      3.242434,
      4,
      0,
      NULL,
      NULL,
      NULL,
      6.933845,
      10,
      NULL,
      6.658983,
      NULL,
      2.729738,
      NULL,
      NULL,
      6.131122,
      2,
      10.564989,
      1.109374,
      2,
      NULL,
      4.369942,
      6.435197,
      6,
      1.935123,
      1.653181,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241604,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.927892,
      NULL,
      NULL,
      1.635742,
      0,
      1.632267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.035990,
      0.862979,
      NULL,
      NULL,
      NULL,
      NULL,
      7.915190,
      0.854830,
      8.236206,
      NULL,
      2,
      0,
      0.370410,
      NULL,
      NULL,
      NULL,
      13,
      1,
      3.856220,
      5,
      2,
      6,
      1.295673,
      1.822097,
      0,
      NULL,
      NULL,
      0.321216,
      3.463947,
      NULL,
      0,
      3.165046,
      3,
      2.353332,
      3.610125,
      1,
      NULL,
      1,
      0.530565,
      0.727791,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.390471,
      '33342',
      '',
      NULL,
      1.076766,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


