set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '04',
      NULL,
      13.619676,
      '1301034',
      128,
      1,
      0.234377,
      2,
      '321034',
      NULL,
      ' 3- 6-1995',
      32.411334,
      42,
      1.385758,
      NULL,
      10.037027,
      2,
      1.624155,
      1,
      3,
      1,
      NULL,
      NULL,
      3.573608,
      1.042128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.919515,
      5,
      1.075561,
      1,
      1.165624,
      7,
      1,
      NULL,
      NULL,
      0,
      3.130031,
      3,
      0.451787,
      NULL,
      NULL,
      1.478226,
      NULL,
      NULL,
      7,
      NULL,
      1.481592,
      0.104749,
      1.284238,
      2,
      2.141153,
      1,
      2,
      1,
      3.475748,
      NULL,
      1.903076,
      0,
      0,
      0,
      2.380083,
      0,
      NULL,
      0,
      2.712529,
      1.111779,
      NULL,
      0,
      2,
      0.418298,
      1,
      NULL,
      NULL,
      1.595556,
      NULL,
      NULL,
      1.830885,
      2.706132,
      1,
      5,
      2,
      NULL,
      1.178135,
      1.157997,
      1,
      1.937633,
      0.208749,
      1,
      1,
      1.712089,
      0.772596,
      1.835123,
      1.492786,
      NULL,
      1.125344,
      NULL,
      0,
      NULL,
      0.219778,
      0,
      3,
      1,
      6.770131,
      NULL,
      2,
      6,
      4,
      1,
      4.583217,
      4.379012,
      0,
      NULL,
      NULL,
      1.360775,
      0.811733,
      8.674801,
      9,
      NULL,
      3.455499,
      5.571084,
      NULL,
      2.419517,
      11,
      6.952848,
      0.296702,
      1.387239,
      1.814598,
      5,
      1.261208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0.346809,
      1.246025,
      0.781756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988333,
      NULL,
      4.349497,
      3.804519,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.111332,
      NULL,
      NULL,
      NULL,
      1.328394,
      2.795201,
      3,
      4.185672,
      0,
      2,
      4,
      0.107415,
      NULL,
      NULL,
      1,
      8.844234,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.645172,
      0.526087,
      1,
      NULL,
      NULL,
      NULL,
      1.830831,
      NULL,
      1,
      NULL,
      1.171285,
      0.728463,
      0,
      0.393580,
      1,
      1.592133,
      1.642502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.708804,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      0.887987,
      '',
      NULL,
      '',
      1.474938,
      '',
      '',
      '',
      5.116968,
      5.242511,
      NULL,
      3.901371,
      1.284492,
      2.928047,
      NULL,
      3,
      2);
commit;
end;
/


