set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '333',
      NULL,
      NULL,
      NULL,
      '4041044',
      43.522506,
      3,
      0,
      1,
      '410131',
      5.353566,
      ' 2- 7-1985',
      1,
      4.221963,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.082104,
      0.735625,
      3,
      0,
      NULL,
      1.148978,
      NULL,
      NULL,
      0.121184,
      0,
      1.647944,
      1.924944,
      1.425507,
      1,
      6.249073,
      NULL,
      3.936583,
      0,
      6.530090,
      NULL,
      2.085597,
      0,
      NULL,
      1.311590,
      NULL,
      NULL,
      NULL,
      0.037298,
      5.361168,
      1.579652,
      1,
      2,
      3.069581,
      0,
      NULL,
      0,
      2.618592,
      2.246263,
      0,
      3,
      0.162364,
      0.737998,
      0.829076,
      0,
      1.539424,
      NULL,
      1.013172,
      NULL,
      1.224014,
      0.542739,
      NULL,
      NULL,
      NULL,
      1,
      1.781819,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.310035,
      1,
      1,
      2.823145,
      6.999068,
      1,
      0.105181,
      1.564499,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.184329,
      1.414679,
      1,
      0,
      NULL,
      0,
      3,
      1,
      0,
      4.680445,
      1.560490,
      0,
      1.908893,
      5.153944,
      1,
      0,
      1.637710,
      NULL,
      1.346238,
      0.144137,
      0.090893,
      NULL,
      9,
      9.903492,
      9.988860,
      0.388292,
      11.962097,
      NULL,
      9.539101,
      2.842706,
      4,
      10,
      2,
      3.607455,
      NULL,
      1.267056,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.316738,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.957784,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.204455,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      9.406506,
      6,
      2,
      NULL,
      5.977972,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2,
      6,
      2.548192,
      1.876062,
      0,
      NULL,
      NULL,
      3.708843,
      1.714194,
      3.716956,
      0.509950,
      3.409039,
      3,
      1.190539,
      0.697558,
      NULL,
      0,
      0.597556,
      NULL,
      1.459486,
      0.713740,
      1.540966,
      0,
      1,
      1.406619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265517,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '02242',
      '',
      NULL,
      0.659336,
      '',
      '',
      '',
      0.334437,
      '',
      '',
      NULL,
      5.784033,
      4.274823,
      3,
      1.264822,
      2.147254,
      1,
      NULL,
      0.487492,
      2.949635);
commit;
end;
/


