set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '040',
      '21442144',
      16,
      9,
      '1004004',
      NULL,
      0,
      2.073268,
      3,
      '034011',
      1,
      ' 2- 5-1998',
      19.320966,
      187,
      NULL,
      NULL,
      1.771814,
      1.700931,
      3,
      1.273083,
      0,
      2.366077,
      1.117300,
      1,
      2,
      0.464639,
      2,
      NULL,
      1.434921,
      1.273341,
      NULL,
      1,
      NULL,
      0.150122,
      0.647684,
      1.770004,
      2.097981,
      NULL,
      6,
      0,
      NULL,
      1.257512,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.699801,
      0,
      2,
      2,
      1.228768,
      0.962736,
      2,
      1.384774,
      2.999094,
      0.494096,
      2,
      1,
      0,
      NULL,
      0.501538,
      0.423439,
      3.468756,
      1,
      1,
      NULL,
      1.921069,
      0,
      5,
      1,
      1,
      1.849803,
      0.958727,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      1,
      9,
      NULL,
      0.390211,
      1,
      NULL,
      1.883332,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0.284127,
      0,
      0,
      0.353969,
      NULL,
      0,
      3,
      1,
      0.430557,
      0,
      1,
      7,
      1,
      2.585351,
      0,
      NULL,
      3.789849,
      8,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.450459,
      6.841681,
      7,
      2,
      3,
      9,
      5.942856,
      NULL,
      5,
      3.089977,
      NULL,
      1,
      0.458147,
      2.518313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.659789,
      1,
      0,
      0,
      NULL,
      NULL,
      1.136113,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      0.886493,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763529,
      1.590128,
      NULL,
      NULL,
      NULL,
      3,
      2.595275,
      10.002998,
      NULL,
      0,
      2,
      0.507603,
      NULL,
      NULL,
      NULL,
      NULL,
      3.118441,
      1.881312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355730,
      2.182671,
      3.168957,
      NULL,
      NULL,
      2,
      0.244402,
      1,
      1.292909,
      3.665665,
      NULL,
      0.785284,
      0.068124,
      1.193825,
      0.652537,
      1,
      0.542335,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.987773,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      4.730364,
      NULL,
      0.000636,
      0.959576,
      2,
      2,
      0.722427,
      0,
      2.781769);
commit;
end;
/


