set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      NULL,
      NULL,
      32.486352,
      '3002403',
      209,
      0,
      0,
      1,
      '022101',
      0,
      NULL,
      40.085610,
      5.761466,
      0.809552,
      NULL,
      19,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2.950670,
      0.608032,
      0.093347,
      0,
      NULL,
      0,
      NULL,
      1.027165,
      1,
      5.259419,
      7.383568,
      1.605382,
      1,
      1.344582,
      0,
      NULL,
      4.118672,
      1,
      4.835272,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.921781,
      1.125909,
      1,
      2,
      0,
      1.906200,
      NULL,
      0,
      3.260730,
      1.288219,
      NULL,
      NULL,
      1.187803,
      2.987606,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.651496,
      1.409835,
      0.646117,
      7,
      1,
      2,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.782005,
      0.556213,
      2.238035,
      NULL,
      1,
      1,
      1,
      1.646765,
      NULL,
      0.889719,
      0,
      0,
      1,
      0.478749,
      0.964794,
      0.731630,
      0.911632,
      0,
      NULL,
      0,
      5,
      0.460276,
      1.319903,
      NULL,
      NULL,
      NULL,
      0.666679,
      NULL,
      8.725210,
      NULL,
      5,
      NULL,
      1.906085,
      3,
      0,
      6.117369,
      9,
      8,
      7,
      2.706562,
      8,
      NULL,
      9,
      9.822783,
      6,
      10,
      2.533717,
      1.953081,
      0,
      1,
      NULL,
      0.923700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.043739,
      1.745176,
      0.556464,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.662233,
      0.578044,
      0.627755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.439642,
      4,
      NULL,
      3.610061,
      2,
      5,
      1,
      NULL,
      NULL,
      1.318324,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.369596,
      NULL,
      2.961443,
      0,
      NULL,
      NULL,
      3,
      3.234454,
      1.391449,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.488976,
      1.862867,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      '11100',
      '4224',
      '',
      0.321951,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      2.843435,
      2,
      2,
      1,
      2.622320,
      0,
      NULL);
commit;
end;
/


