set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '034',
      '20210412',
      7.796184,
      27,
      NULL,
      NULL,
      5,
      0,
      1,
      '341142',
      2.618893,
      ' 7-13-1997',
      57.428794,
      4,
      0,
      NULL,
      NULL,
      3,
      1,
      1,
      3.971812,
      1.997667,
      2.733359,
      0.301342,
      NULL,
      1.460661,
      6,
      1.265538,
      0,
      1.410631,
      0.773689,
      0.567164,
      3.345283,
      NULL,
      3.620007,
      NULL,
      4,
      NULL,
      2.010470,
      NULL,
      0,
      NULL,
      2.660057,
      NULL,
      NULL,
      NULL,
      1.191631,
      NULL,
      NULL,
      6,
      0.472477,
      NULL,
      0.819687,
      2.984865,
      NULL,
      1,
      2.462975,
      0,
      3.848497,
      2,
      1.221812,
      0,
      NULL,
      0.642109,
      NULL,
      NULL,
      0.381443,
      NULL,
      1,
      1,
      5,
      1.784395,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0.603940,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      8,
      NULL,
      NULL,
      0.234088,
      1.427895,
      1,
      1,
      0.445820,
      1,
      0,
      0,
      NULL,
      1,
      1.752299,
      1.605805,
      NULL,
      0,
      NULL,
      1.473635,
      5,
      3.827109,
      1,
      2,
      0.529181,
      NULL,
      3.711313,
      7.785477,
      0,
      NULL,
      2,
      2.992300,
      1,
      NULL,
      6.929243,
      7,
      8,
      NULL,
      4,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      2,
      0,
      0.681051,
      0.648269,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.493042,
      1,
      1,
      0.706837,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.927136,
      NULL,
      6.351465,
      3,
      0,
      1.799293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.487941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273508,
      2,
      1.459231,
      7,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.573315,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.017769,
      0.806352,
      2,
      NULL,
      2.802853,
      0.574360,
      2.143969,
      NULL,
      NULL,
      0.440757,
      NULL,
      0,
      1.057374,
      0.015287,
      0.458535,
      NULL,
      0.671732,
      NULL,
      1,
      0.401867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '02131',
      '3234',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.170318,
      NULL,
      NULL,
      2,
      0,
      3.524312,
      1.165022,
      0.317304,
      3.332581);
commit;
end;
/


