set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00323410',
      46.157293,
      61.260403,
      '4004031',
      280,
      1,
      3.567052,
      3,
      '024224',
      NULL,
      '10-11-1977',
      57,
      18.425292,
      NULL,
      NULL,
      NULL,
      1.671734,
      1,
      1.873104,
      2,
      NULL,
      1,
      1.813397,
      3.803365,
      0.522711,
      2,
      1.674579,
      0.767046,
      1,
      0.278901,
      5.242792,
      7.848925,
      1,
      1.056588,
      0.116625,
      1.568397,
      NULL,
      NULL,
      1,
      NULL,
      3,
      3.362347,
      1.882460,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.252516,
      1.113555,
      1,
      1.632299,
      NULL,
      0.935290,
      1.862829,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.558759,
      1.654642,
      1.886884,
      0,
      0.909567,
      0.544834,
      0.040475,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963833,
      NULL,
      8,
      3,
      0.386461,
      1.191769,
      0,
      1,
      0.036378,
      1.269830,
      0,
      0.953234,
      0,
      0.065646,
      NULL,
      NULL,
      1.549374,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      6,
      1,
      5.417852,
      0,
      NULL,
      4,
      11.606069,
      2.338397,
      6.242088,
      NULL,
      NULL,
      3.853710,
      7.512973,
      7,
      1,
      3,
      1.814119,
      NULL,
      NULL,
      1,
      9.301608,
      3.824181,
      0,
      NULL,
      1,
      NULL,
      1.553876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606195,
      1,
      0,
      0,
      NULL,
      0.530512,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.557797,
      NULL,
      NULL,
      3.762563,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.572224,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.173723,
      4,
      5,
      4,
      2,
      2.706446,
      0.827221,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.184154,
      NULL,
      NULL,
      1.253495,
      2,
      1,
      0,
      NULL,
      3.747986,
      0.520652,
      NULL,
      0.204034,
      0,
      1,
      0,
      1,
      0.996516,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.899476,
      '12302',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      1.299331,
      '4440',
      '',
      '',
      0,
      0,
      0,
      NULL,
      2.710743,
      0,
      2.916003,
      3,
      2.365364);
commit;
end;
/


