set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10132123',
      51,
      NULL,
      NULL,
      117,
      NULL,
      0,
      NULL,
      '130040',
      6,
      ' 2-18-1995',
      25.635317,
      31.060780,
      0,
      NULL,
      NULL,
      1.965258,
      3.389141,
      NULL,
      1.220521,
      0,
      0.492163,
      NULL,
      3,
      0.977816,
      3.197630,
      0,
      1.535139,
      NULL,
      0.407833,
      2,
      7.425953,
      0,
      1.062224,
      0.632770,
      1.013680,
      NULL,
      6.063053,
      NULL,
      4,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.122018,
      0.355388,
      0.195786,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      2,
      1,
      1,
      2.226255,
      1,
      1,
      3.540904,
      0,
      1,
      1.228882,
      2.122008,
      2.860976,
      4.229225,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.715881,
      0.905632,
      1.650905,
      NULL,
      0.850239,
      1.466413,
      0.650957,
      1,
      1.400852,
      1,
      0.003284,
      1,
      0,
      1.780008,
      0.481211,
      1,
      0.824738,
      NULL,
      0,
      5.500974,
      0,
      NULL,
      3,
      7.614349,
      NULL,
      0.151759,
      7.361627,
      NULL,
      NULL,
      4,
      7,
      2,
      5.409712,
      1,
      11.883103,
      8.664666,
      1,
      9.820504,
      2.175119,
      1,
      1.319447,
      1,
      5.384950,
      4,
      9,
      6,
      NULL,
      0,
      1,
      1.398369,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      0.829127,
      NULL,
      0.031910,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.196118,
      NULL,
      7,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.768509,
      NULL,
      NULL,
      NULL,
      0.374554,
      1,
      7,
      NULL,
      1.637192,
      1,
      0.963809,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.132595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      2,
      3,
      3.008926,
      1,
      1,
      NULL,
      0.318924,
      NULL,
      0.015800,
      1.031140,
      0.066889,
      1.084825,
      1.646186,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.285966,
      '10411',
      '1243',
      '',
      NULL,
      NULL,
      NULL,
      '',
      3,
      '0311',
      '',
      '',
      0,
      3.780494,
      2.694064,
      0.195267,
      3.647663,
      1,
      2,
      2,
      1.495219);
commit;
end;
/


