set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '13023432',
      53.256876,
      NULL,
      '2430140',
      242.753401,
      0,
      NULL,
      0,
      '003210',
      4.398449,
      NULL,
      41.694892,
      6.984718,
      1,
      NULL,
      17.854307,
      1,
      3.942749,
      NULL,
      1.668030,
      0.097304,
      1.950108,
      NULL,
      1,
      0.766255,
      9,
      0.903854,
      0,
      NULL,
      1,
      NULL,
      2,
      0.363926,
      2.992971,
      1.165259,
      0,
      1.879586,
      NULL,
      1,
      5.920886,
      3.343986,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.569130,
      2.002733,
      0,
      0,
      3.769507,
      3,
      3,
      2,
      NULL,
      1.947480,
      1,
      2,
      1,
      NULL,
      2.439612,
      0.691279,
      1.683050,
      0,
      NULL,
      1,
      4,
      1,
      2,
      NULL,
      0.790407,
      NULL,
      NULL,
      0.556660,
      NULL,
      NULL,
      NULL,
      NULL,
      1.732952,
      4.648213,
      NULL,
      0,
      1.557761,
      0,
      1.227704,
      NULL,
      1.682157,
      0,
      1.738479,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.365000,
      NULL,
      0,
      0.872729,
      1,
      NULL,
      1.779771,
      NULL,
      1,
      4.852482,
      0,
      NULL,
      7,
      5.136764,
      3.193170,
      NULL,
      NULL,
      5.773684,
      0,
      8.988789,
      NULL,
      NULL,
      6.717062,
      3.136905,
      NULL,
      5.280271,
      7.694263,
      2,
      2.822146,
      0,
      0,
      2.824349,
      1.978625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.265490,
      NULL,
      NULL,
      0,
      0.790368,
      1.603831,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.369438,
      1,
      2.210360,
      1.433043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.735863,
      2,
      1.374363,
      NULL,
      NULL,
      NULL,
      0.370135,
      4.610749,
      5,
      NULL,
      3.253295,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.571847,
      3.291171,
      3,
      3.957499,
      2,
      3.505382,
      1,
      1.253445,
      3,
      NULL,
      1,
      NULL,
      0,
      0.927025,
      1,
      0.396634,
      0.686956,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '10312',
      '0101',
      '',
      NULL,
      '',
      '',
      '',
      0.655021,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3,
      2,
      0.181656,
      0.285478,
      0);
commit;
end;
/


