set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3110',
      '04332434',
      26,
      41.060749,
      '1224330',
      NULL,
      0,
      NULL,
      2,
      '334011',
      0.479273,
      '10- 6-2003',
      NULL,
      6.839040,
      0.149684,
      NULL,
      0,
      0,
      2.051231,
      NULL,
      0,
      3.530444,
      0,
      0,
      NULL,
      1,
      6,
      1.272012,
      1,
      1.287097,
      0.481008,
      0,
      NULL,
      NULL,
      NULL,
      0.824073,
      0,
      0.570325,
      7.934161,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.811104,
      2.423366,
      3,
      1,
      3,
      3.857775,
      1,
      NULL,
      0.093833,
      2.989197,
      1.428847,
      0,
      1,
      0.775292,
      2.975756,
      1.289643,
      1,
      0.802975,
      0,
      5.182188,
      NULL,
      5.431296,
      0,
      0,
      0.058202,
      0.249824,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.740857,
      9,
      1,
      1.588348,
      1,
      0,
      0.546163,
      0.628774,
      1,
      0.352478,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.598155,
      1.031578,
      3.330813,
      7,
      4,
      4,
      0,
      0.535290,
      6,
      1.036650,
      NULL,
      NULL,
      1,
      6,
      0.895642,
      6,
      4.698854,
      8,
      6,
      4.579988,
      9.282646,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.606550,
      3,
      1.066322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.238621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.348071,
      2,
      0,
      5.808953,
      6.277582,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1.303382,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730074,
      2,
      NULL,
      NULL,
      0.312346,
      3,
      3.915618,
      2.113185,
      NULL,
      1,
      3.451732,
      1.781523,
      0,
      NULL,
      0,
      1.484387,
      0.081865,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.829597,
      NULL,
      '1314',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      3.822184,
      3,
      1,
      0.547821,
      0.057487,
      0.601733,
      0.996749,
      0,
      0);
commit;
end;
/


