set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1112',
      '12302131',
      31,
      81.121825,
      '2204313',
      NULL,
      1,
      3.908807,
      2,
      '011101',
      1.814206,
      ' 0-18-1989',
      42,
      24.255555,
      1,
      NULL,
      14,
      0.734732,
      0.871315,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084523,
      3.077222,
      0,
      7.161099,
      1.705817,
      1.873435,
      0,
      NULL,
      3,
      3.186821,
      1.793373,
      5.464175,
      1.155883,
      2.164723,
      1,
      1.891315,
      0,
      1,
      NULL,
      0.921086,
      1.654765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191316,
      NULL,
      1.403713,
      1.073585,
      3,
      1.766253,
      2,
      2,
      0,
      NULL,
      1.179357,
      0,
      NULL,
      1,
      2,
      0,
      0.696467,
      1.315916,
      NULL,
      0.198566,
      1,
      4.618941,
      0,
      1,
      3.309695,
      NULL,
      NULL,
      NULL,
      1.211292,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      8.317541,
      5.456954,
      0,
      1,
      1,
      1.211794,
      0,
      0,
      1,
      1,
      1,
      0,
      1.660532,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.682241,
      1.780709,
      NULL,
      3.613986,
      NULL,
      3.218104,
      NULL,
      NULL,
      NULL,
      2.237909,
      3.745933,
      0,
      6,
      1,
      NULL,
      3,
      2,
      9,
      4,
      7.769014,
      4,
      2,
      4,
      2,
      NULL,
      NULL,
      NULL,
      2.084577,
      1.957404,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633792,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.042947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.003995,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.309908,
      NULL,
      NULL,
      NULL,
      1,
      0.440339,
      7,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.090364,
      NULL,
      NULL,
      2,
      1.213734,
      1,
      0.503047,
      0.034137,
      1,
      0,
      0.832169,
      1.936037,
      NULL,
      1.416671,
      0.217311,
      1.329939,
      0,
      1.080627,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '1442',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '2044',
      '',
      '',
      2,
      1.423043,
      1.447514,
      1,
      1.561429,
      3,
      3,
      2.050836,
      NULL);
commit;
end;
/


