set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4200',
      '1',
      57.515141,
      50.799607,
      '0224313',
      310.186704,
      NULL,
      1,
      1,
      '232303',
      5.613818,
      ' 9-23-1977',
      26,
      4.391912,
      NULL,
      NULL,
      9.094363,
      1.711666,
      0.497380,
      1,
      0.778451,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      0.791956,
      0.072840,
      0.654372,
      1,
      2.374340,
      5,
      NULL,
      5.122109,
      0,
      4.959669,
      0,
      6.260494,
      0,
      NULL,
      NULL,
      0,
      0.558188,
      NULL,
      NULL,
      0.852692,
      NULL,
      NULL,
      2,
      1.722657,
      2,
      NULL,
      NULL,
      NULL,
      1.676890,
      0.924106,
      2.565067,
      3.839660,
      1.268601,
      1.266513,
      0.151971,
      0.354381,
      0,
      0,
      2,
      0,
      1.445546,
      NULL,
      5,
      1,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.553725,
      NULL,
      NULL,
      0,
      0,
      0.313644,
      8.791046,
      0,
      1.759757,
      1,
      0.165530,
      0.790698,
      1,
      1,
      1.049914,
      1,
      1,
      1.665369,
      1,
      NULL,
      0,
      0.322797,
      NULL,
      NULL,
      1.870697,
      0,
      NULL,
      6.554315,
      NULL,
      6.492188,
      0.205378,
      NULL,
      9,
      6.332278,
      NULL,
      4.138103,
      2,
      5,
      NULL,
      NULL,
      3,
      9,
      8,
      0,
      1,
      4,
      8.204677,
      3,
      6,
      NULL,
      3.291903,
      2,
      1,
      NULL,
      NULL,
      1.868162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.257863,
      NULL,
      1,
      0,
      1.969203,
      1.535946,
      0.156431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.351669,
      NULL,
      9.651130,
      2.372559,
      0.319450,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923706,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.814064,
      7,
      6,
      8,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175936,
      10.487286,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      3.103027,
      NULL,
      NULL,
      0,
      3,
      0,
      3,
      0.670504,
      0.741180,
      1,
      1.548212,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.852842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4.479541,
      NULL,
      '3433',
      '',
      0.566207,
      '',
      NULL,
      NULL,
      2,
      '1344',
      '',
      '',
      NULL,
      NULL,
      3,
      0,
      3.804736,
      3.325182,
      2.206531,
      0.193666,
      NULL);
commit;
end;
/


