set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8003246';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21010023',
      77.983821,
      9,
      NULL,
      222,
      NULL,
      0.301697,
      0,
      '031210',
      1,
      ' 5-26-1975',
      27,
      58,
      1.039144,
      NULL,
      1.761291,
      0.362400,
      1.080083,
      1.333131,
      1.505506,
      0.856981,
      1.268742,
      0,
      2,
      1.048146,
      5.794805,
      1,
      0,
      0,
      0.348184,
      4.145288,
      3.171788,
      0,
      3.136502,
      0,
      2,
      1.024719,
      3.549368,
      1,
      3,
      1,
      1,
      0,
      NULL,
      NULL,
      0.946629,
      4,
      2,
      3,
      1,
      4.010058,
      0,
      1.893658,
      0.459668,
      NULL,
      0,
      3,
      0,
      0,
      0,
      0,
      1.813138,
      1.263664,
      0,
      NULL,
      1,
      NULL,
      1,
      2.496406,
      4.805340,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3,
      0.454791,
      0.395214,
      NULL,
      0.952315,
      2,
      1.153577,
      NULL,
      NULL,
      1.114113,
      1.799370,
      0,
      0.866349,
      0.560505,
      1.347947,
      0.215487,
      0.368910,
      0,
      0.526141,
      0.000869,
      NULL,
      0.511249,
      1,
      1.328092,
      NULL,
      0.925482,
      2.232342,
      NULL,
      0,
      NULL,
      7.386201,
      NULL,
      7.408894,
      7,
      NULL,
      0,
      1.760419,
      9,
      9,
      NULL,
      3.378601,
      NULL,
      7.020078,
      0.803385,
      0,
      NULL,
      2.645471,
      2.420350,
      2,
      2.905084,
      NULL,
      1.203108,
      4.078856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1.838792,
      1.888658,
      1,
      0.283932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      8.200687,
      NULL,
      2.568445,
      0.516509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.059091,
      NULL,
      1.970094,
      NULL,
      NULL,
      NULL,
      NULL,
      5.048567,
      4.131956,
      9.145444,
      2,
      1,
      2.439575,
      0,
      NULL,
      NULL,
      0,
      8,
      3,
      NULL,
      0,
      3,
      1,
      0.843454,
      1,
      0.856777,
      1,
      3,
      2.542936,
      NULL,
      0.849171,
      NULL,
      3,
      3,
      3.727425,
      0,
      0.884561,
      0.324306,
      NULL,
      0.079254,
      1,
      1,
      1,
      NULL,
      0.872697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '04304',
      '1303',
      NULL,
      1,
      NULL,
      '',
      '',
      1,
      '2031',
      NULL,
      '',
      NULL,
      1,
      2.817434,
      0.527148,
      1.129946,
      2,
      1,
      NULL,
      3.123643);
commit;
end;
/


