set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '40',
      10.442377,
      12.989718,
      '0412243',
      NULL,
      NULL,
      2.185491,
      3,
      '001312',
      4,
      ' 3-22-1977',
      40.849540,
      NULL,
      0.452344,
      NULL,
      1.154992,
      NULL,
      1.642588,
      0,
      NULL,
      1.253462,
      0.911813,
      1,
      0.550965,
      0.716653,
      1,
      NULL,
      NULL,
      1.612453,
      1.000288,
      1,
      0.614216,
      0,
      0,
      NULL,
      1.971653,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.085717,
      1,
      0.190316,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.533141,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565741,
      0,
      5.392031,
      NULL,
      0.610141,
      1,
      0,
      0.343968,
      1.849247,
      NULL,
      1,
      0.343276,
      0.464079,
      0.141436,
      1,
      0.139668,
      0,
      NULL,
      0.699802,
      NULL,
      1.469745,
      NULL,
      1.811472,
      1.120409,
      NULL,
      1.323814,
      6.105278,
      NULL,
      5,
      4,
      NULL,
      NULL,
      0.546291,
      0.660186,
      5,
      1.230513,
      1.879634,
      3.239695,
      NULL,
      7,
      6,
      11.003318,
      NULL,
      7,
      8.427647,
      NULL,
      NULL,
      NULL,
      1.292080,
      NULL,
      NULL,
      5.781757,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.114142,
      1,
      0,
      NULL,
      0.294353,
      NULL,
      NULL,
      1.497845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.048614,
      NULL,
      NULL,
      2.630134,
      1.732266,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3.221302,
      NULL,
      0.917627,
      1.802876,
      6,
      10,
      6,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      1.572464,
      11.774205,
      0.098353,
      1,
      4,
      0.058470,
      7.650108,
      NULL,
      0,
      1,
      NULL,
      2.075707,
      0,
      3.019020,
      1.726994,
      3,
      NULL,
      1.929326,
      NULL,
      0.810150,
      1.869021,
      NULL,
      0,
      0.829691,
      1.344593,
      0,
      0.175189,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '02224',
      '',
      '',
      0.350467,
      '',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '',
      1.003251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


