set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9027574';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '410',
      '10',
      6.337533,
      0.719227,
      '2121002',
      54.758283,
      4,
      3.784245,
      2,
      '431310',
      NULL,
      ' 5-28-1980',
      21,
      42.298738,
      0.820032,
      NULL,
      1.310118,
      1,
      NULL,
      0.817419,
      1,
      0.259150,
      NULL,
      NULL,
      0,
      NULL,
      1.380275,
      0,
      0,
      0.609054,
      NULL,
      1.519420,
      0.127720,
      1,
      1,
      NULL,
      0.371460,
      1.757859,
      4,
      0,
      1.437496,
      1.786038,
      NULL,
      1.070679,
      NULL,
      NULL,
      3,
      0.163685,
      NULL,
      1,
      0.753996,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.555278,
      1,
      1.958087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066164,
      1.119934,
      NULL,
      4,
      1.952591,
      0,
      0.471555,
      0,
      1.940735,
      0.554792,
      1,
      1.351707,
      NULL,
      0.868666,
      1.800863,
      1.893426,
      NULL,
      0,
      0,
      NULL,
      NULL,
      3.291626,
      1.339672,
      1,
      NULL,
      0.672035,
      7.470560,
      0.978605,
      2,
      6,
      NULL,
      5,
      5.110365,
      NULL,
      5.298882,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3.344819,
      8.236839,
      11,
      8,
      3,
      NULL,
      NULL,
      7.730607,
      NULL,
      NULL,
      NULL,
      5.908931,
      0.985774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.154793,
      0,
      1,
      1.096895,
      1,
      1,
      1.686311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.490016,
      NULL,
      3.427994,
      2,
      1,
      1.287098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      10,
      9.041549,
      NULL,
      0,
      5.269213,
      0,
      NULL,
      NULL,
      NULL,
      13.398496,
      2,
      4,
      5,
      3,
      10.945015,
      0,
      0.402460,
      1,
      0,
      0,
      1.552709,
      1.834296,
      2.174606,
      3,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.137136,
      0.655318,
      0,
      NULL,
      0.121830,
      1,
      1.282083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '10244',
      '',
      '',
      1.719653,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      4.821478,
      3,
      NULL,
      3.760100,
      3.335798,
      2,
      NULL,
      3,
      3);
commit;
end;
/


