set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9622970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '014',
      '44',
      2,
      19.145869,
      '3320211',
      10,
      3,
      3.676598,
      NULL,
      NULL,
      NULL,
      ' 9-27-1974',
      65.832386,
      40,
      1,
      NULL,
      NULL,
      0.263266,
      3,
      0.036481,
      1,
      1,
      1.340876,
      3.139395,
      1.622329,
      1.998591,
      1,
      0,
      NULL,
      1,
      5.994954,
      1,
      5.692886,
      0,
      0,
      0,
      1.748398,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.375043,
      0.750137,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.987838,
      0.799748,
      0,
      1.784300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.614286,
      0,
      NULL,
      0.084485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.599271,
      0.445628,
      0,
      1,
      3,
      3.630900,
      0,
      0.835444,
      4,
      NULL,
      NULL,
      NULL,
      3.953326,
      1,
      NULL,
      0.277455,
      1.002553,
      1.818628,
      NULL,
      1.647146,
      1,
      0,
      0.929231,
      0.272002,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203989,
      0.285063,
      1,
      1,
      0.075278,
      1.197711,
      1.845627,
      NULL,
      4.044706,
      1.038850,
      3.355670,
      4.758185,
      3,
      0.122539,
      NULL,
      0.796005,
      1.308396,
      NULL,
      NULL,
      8.120261,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478513,
      0,
      0,
      1,
      1,
      1.807025,
      0.978853,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.189670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457166,
      NULL,
      1.334225,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748948,
      0.432076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779496,
      3,
      3.128577,
      1.245378,
      0.635149,
      3,
      0,
      1.272900,
      NULL,
      NULL,
      0,
      0,
      1,
      0.720270,
      0,
      1.076110,
      NULL,
      1.076701,
      1.531139,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '22044',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      4.849422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


