set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9904910';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20310223',
      77,
      25,
      NULL,
      6.226202,
      4,
      0,
      NULL,
      '404004',
      0.677253,
      NULL,
      17.418930,
      63,
      NULL,
      NULL,
      3.592236,
      0.673409,
      1,
      0.611032,
      1.179854,
      NULL,
      1,
      1.529275,
      NULL,
      NULL,
      1.365999,
      0,
      NULL,
      NULL,
      0.325277,
      NULL,
      1.260860,
      NULL,
      1,
      NULL,
      NULL,
      1.732453,
      6,
      NULL,
      0.488328,
      0,
      2.069454,
      1.986800,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.071835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.317372,
      2.397727,
      1,
      NULL,
      0.505217,
      0,
      NULL,
      NULL,
      0.843516,
      NULL,
      NULL,
      0.244876,
      NULL,
      NULL,
      5,
      4.773026,
      1,
      0,
      0,
      1.489068,
      1.991972,
      0,
      1.005736,
      0,
      1.215389,
      0,
      1.303880,
      1.411419,
      0.062800,
      0,
      NULL,
      0.315151,
      5.702979,
      0.698360,
      2,
      5,
      1,
      NULL,
      1,
      1,
      0.431046,
      0,
      1.839745,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      5,
      3,
      2.842818,
      NULL,
      NULL,
      0,
      7.986891,
      2,
      0.643561,
      3.280546,
      3,
      0.465078,
      NULL,
      4.731920,
      0.614312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.082072,
      0,
      NULL,
      NULL,
      0,
      1,
      0.225096,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.625915,
      3,
      3,
      0,
      1.276028,
      0.680669,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.119053,
      0.646873,
      1,
      NULL,
      0.768277,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.688705,
      1.562345,
      1,
      1,
      1.479239,
      0.238808,
      0,
      1,
      2.700115,
      NULL,
      1.956257,
      0,
      0,
      1.148011,
      1.361796,
      0,
      0.529317,
      0.634791,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.147156,
      '01422',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.342219,
      NULL,
      NULL,
      '',
      5.173944,
      NULL,
      NULL,
      0,
      3.208704,
      3.873948,
      NULL,
      NULL,
      0);
commit;
end;
/


