set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9904910';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '40403111',
      0,
      18,
      '1402114',
      NULL,
      2,
      1.866218,
      0,
      '231012',
      NULL,
      ' 3-17-1996',
      NULL,
      22,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.479572,
      1,
      3.715525,
      NULL,
      1,
      2,
      1,
      3.126660,
      1.907766,
      NULL,
      1.747091,
      1.010306,
      NULL,
      1.136510,
      1,
      0,
      1,
      1,
      0.501086,
      5,
      1,
      3,
      1.571644,
      2.765599,
      0,
      NULL,
      NULL,
      1.651770,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.825607,
      NULL,
      1.294142,
      0,
      0,
      0,
      0.948334,
      0,
      NULL,
      NULL,
      1.336972,
      NULL,
      NULL,
      1.733655,
      NULL,
      4,
      6.274146,
      6,
      1.967179,
      1.653717,
      NULL,
      0,
      1.364240,
      NULL,
      NULL,
      NULL,
      1,
      0.050750,
      1,
      1,
      0.169437,
      1.072781,
      NULL,
      NULL,
      2,
      0.780755,
      0,
      0,
      NULL,
      NULL,
      1,
      5,
      0,
      1.923939,
      1.774370,
      1.479943,
      1.017720,
      4.315571,
      NULL,
      0,
      4,
      1.405342,
      0,
      1.601173,
      NULL,
      5,
      7.944593,
      3,
      1.600873,
      1,
      NULL,
      0,
      1,
      0.242325,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0.929384,
      0.624294,
      1.751667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.866262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.400569,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.501031,
      NULL,
      4.574432,
      5,
      0.822713,
      1,
      0.452471,
      NULL,
      NULL,
      NULL,
      0.012962,
      0,
      0.891548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.092475,
      3,
      1,
      1,
      3.206257,
      NULL,
      3,
      1,
      2.890935,
      NULL,
      1.341147,
      1.307293,
      NULL,
      NULL,
      1.814801,
      0.321085,
      1.352389,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.632910,
      NULL,
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3,
      2.091780,
      0.288739,
      2.334486,
      2,
      3,
      1,
      1.378680,
      2);
commit;
end;
/


