set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9904910';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2021',
      NULL,
      78.384989,
      NULL,
      '3020133',
      0,
      1,
      2,
      0,
      NULL,
      5,
      ' 2- 5-1983',
      31.798904,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      0.431156,
      1,
      1.254424,
      2,
      0,
      NULL,
      0.171504,
      NULL,
      0,
      3.201654,
      1,
      0.003435,
      1,
      1,
      0,
      5.107053,
      1,
      3,
      2.643658,
      1,
      1.811111,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.297002,
      1.071125,
      1.140714,
      1.944977,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.290489,
      0.776128,
      5.948930,
      0,
      NULL,
      1,
      1.641642,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.185301,
      5.999140,
      5.999062,
      6,
      0.197498,
      1,
      0,
      0,
      1.251575,
      1,
      0,
      0.806137,
      1.738981,
      NULL,
      0.292447,
      0.459789,
      0.630209,
      1,
      NULL,
      NULL,
      0.531559,
      NULL,
      1.456052,
      1.522307,
      0,
      1,
      NULL,
      1,
      1.556234,
      0,
      4,
      0.888847,
      NULL,
      3,
      0,
      NULL,
      NULL,
      5,
      4.045611,
      NULL,
      5.505915,
      0,
      1,
      1,
      7,
      4.285044,
      3,
      1.550331,
      0,
      1.135273,
      1,
      6.297604,
      0.006799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.311767,
      NULL,
      NULL,
      1.853083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.031416,
      0.518164,
      3,
      0.867776,
      1.542591,
      3,
      3.578476,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.472020,
      0,
      1,
      2,
      1.015113,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.920360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.288041,
      1.878398,
      2,
      2.611293,
      NULL,
      0,
      0.838945,
      0.131237,
      1,
      1,
      0,
      1.530204,
      0,
      0.817324,
      NULL,
      0,
      0,
      0.005075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '',
      0.013625,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      0,
      4.048756,
      0.665117,
      1,
      2.586800,
      1,
      NULL,
      1);
commit;
end;
/


