set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      9.492617,
      2,
      2,
      1,
      '031100',
      NULL,
      NULL,
      8,
      NULL,
      1.704719,
      NULL,
      2.612168,
      0.832978,
      1.461820,
      1.557186,
      1.702393,
      2,
      0,
      1,
      NULL,
      NULL,
      1.271378,
      NULL,
      0.056603,
      3.556164,
      NULL,
      5.730138,
      2,
      NULL,
      3,
      NULL,
      6.913602,
      3.288289,
      NULL,
      NULL,
      2.960919,
      NULL,
      5,
      1.676588,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.174059,
      NULL,
      NULL,
      1.139437,
      1.313599,
      1.862528,
      NULL,
      0,
      2,
      1.955552,
      1,
      1.372027,
      0,
      3.575069,
      NULL,
      NULL,
      3.662043,
      0,
      1.126971,
      5.093963,
      0,
      4,
      1.331996,
      1,
      NULL,
      0.858747,
      1.379806,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.802848,
      0.156737,
      0.563865,
      0,
      NULL,
      1.501838,
      0.290812,
      1.439495,
      0.587297,
      1.436430,
      NULL,
      0.448115,
      5,
      NULL,
      1.525125,
      4.505515,
      1,
      3.739530,
      1,
      5.648625,
      1.964198,
      NULL,
      1.572110,
      NULL,
      7.552711,
      7,
      NULL,
      1.356518,
      2,
      6.529705,
      5,
      8,
      2,
      0.683595,
      4.703421,
      NULL,
      4,
      5,
      4.741934,
      2.024758,
      0.044412,
      NULL,
      2.418664,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1.162986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.426726,
      NULL,
      NULL,
      1,
      0,
      3.876588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.745724,
      NULL,
      NULL,
      NULL,
      0.790262,
      0,
      7.648918,
      0.675228,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719778,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.586869,
      2,
      1.933839,
      3.806473,
      NULL,
      NULL,
      1.145978,
      NULL,
      2,
      NULL,
      1.469930,
      1.643949,
      1.493961,
      1.063554,
      0.184066,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.406959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '44040',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.005577,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


