set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '1223343',
      12,
      5,
      1.376398,
      0,
      NULL,
      3,
      ' 9-10-1997',
      6.912168,
      NULL,
      1.182621,
      NULL,
      8.651462,
      3.559481,
      1.374146,
      0,
      3.985065,
      0,
      0,
      1,
      3.531079,
      1,
      NULL,
      1.255765,
      0,
      0.181911,
      1,
      0,
      2,
      NULL,
      0,
      5,
      1.945949,
      3,
      7,
      1,
      2,
      4,
      2.537833,
      1.667946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      1,
      1,
      2.579414,
      1,
      1.653129,
      0.091930,
      0.480316,
      0,
      1,
      NULL,
      1.258498,
      0,
      0.339507,
      1,
      NULL,
      0,
      1.158359,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.171493,
      0,
      NULL,
      0,
      3,
      1,
      1.409662,
      0.001288,
      0.169559,
      NULL,
      0,
      4,
      1,
      1.150318,
      1,
      NULL,
      1,
      NULL,
      0.502530,
      3,
      0,
      0.329834,
      NULL,
      1.942661,
      2,
      NULL,
      4.166004,
      2.914349,
      NULL,
      2,
      1,
      1.232804,
      3.017643,
      NULL,
      2,
      2,
      3,
      3,
      5.126178,
      0.320210,
      7.536513,
      4,
      7.015660,
      4.381582,
      NULL,
      6.332797,
      2,
      1,
      1.676599,
      1,
      1.828711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      2,
      0.942404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145075,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      9,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.855738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.767964,
      2.649905,
      1,
      1,
      0,
      1,
      1.702600,
      2,
      2.774495,
      NULL,
      0.385452,
      0.222016,
      1.680138,
      1.989653,
      0.682925,
      NULL,
      0.700994,
      0,
      0,
      1.590372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      1.014647,
      '',
      '',
      '',
      1.034518,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


