set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '1043344',
      49,
      6,
      0,
      NULL,
      '010011',
      NULL,
      ' 1- 3-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.387759,
      NULL,
      1.300897,
      0,
      0,
      0.260158,
      1,
      2.050664,
      1.241801,
      1.158855,
      1.702688,
      NULL,
      0,
      0,
      NULL,
      0.663473,
      NULL,
      4.022542,
      1.523753,
      1.396354,
      1.090070,
      3,
      NULL,
      4.928499,
      1,
      1,
      0,
      NULL,
      NULL,
      0.050270,
      NULL,
      NULL,
      0,
      0,
      0,
      1.940948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951120,
      1,
      1,
      1.646068,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1.812074,
      1.901693,
      1.856614,
      0.850418,
      NULL,
      0.611230,
      1.356547,
      1,
      0.085818,
      1.854101,
      NULL,
      NULL,
      0,
      1.259556,
      NULL,
      0.244179,
      10,
      1.929556,
      0.332255,
      0,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657791,
      3.486134,
      0.726862,
      1,
      5,
      3.302415,
      1.990003,
      NULL,
      NULL,
      NULL,
      4,
      11,
      2,
      NULL,
      5.277207,
      NULL,
      0.096670,
      NULL,
      NULL,
      2,
      0.899641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.064443,
      1.960043,
      1,
      1,
      1.958413,
      1.660167,
      0.325365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.818531,
      NULL,
      NULL,
      NULL,
      NULL,
      2.894564,
      1,
      1,
      NULL,
      3.693563,
      NULL,
      2.316868,
      2.269196,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.490550,
      NULL,
      2,
      1,
      2,
      1.126959,
      0,
      NULL,
      NULL,
      NULL,
      6,
      0.893628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.976876,
      NULL,
      2,
      0.516742,
      NULL,
      1,
      3,
      1.028076,
      NULL,
      0.241725,
      1.794337,
      0.909979,
      0.227204,
      0,
      0,
      1,
      NULL,
      1.114422,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '40310',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


