set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '0443312',
      35,
      0,
      0,
      2,
      '233041',
      3,
      '10- 4-1989',
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.285207,
      1.878092,
      1.594425,
      0,
      1,
      0.818247,
      NULL,
      2,
      1,
      0.575448,
      0,
      1.515980,
      0.648058,
      0,
      NULL,
      NULL,
      1,
      4,
      0,
      0.740893,
      1.856666,
      4,
      NULL,
      NULL,
      1.480817,
      NULL,
      0,
      NULL,
      NULL,
      0.158723,
      NULL,
      NULL,
      6.463526,
      2,
      0,
      0.066752,
      1,
      1.988864,
      1.265353,
      2.677585,
      NULL,
      1,
      2,
      1,
      0.338488,
      2,
      2.422967,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1.673019,
      0,
      0,
      0,
      1.365564,
      0,
      NULL,
      NULL,
      0.633253,
      NULL,
      NULL,
      0,
      0,
      0.368796,
      1.144248,
      0.863267,
      1.327839,
      1.489372,
      NULL,
      1,
      1.735283,
      NULL,
      1.326138,
      NULL,
      0,
      0.041749,
      1.201766,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      2.338997,
      NULL,
      NULL,
      0.992960,
      1,
      NULL,
      NULL,
      4.999826,
      NULL,
      0.936181,
      NULL,
      0,
      5,
      6,
      NULL,
      NULL,
      6.897828,
      4.764830,
      0.693097,
      6,
      NULL,
      2,
      0,
      1.482620,
      1,
      NULL,
      NULL,
      NULL,
      1.139511,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872042,
      0.440259,
      1,
      0,
      1.887150,
      1,
      0.647070,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.038854,
      NULL,
      NULL,
      NULL,
      NULL,
      1.610027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.144539,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3.688041,
      9,
      NULL,
      0.628834,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.644421,
      NULL,
      NULL,
      0,
      1.664931,
      3.702588,
      3,
      NULL,
      0,
      0.683260,
      3.079832,
      NULL,
      1.388560,
      1,
      NULL,
      0,
      1.562194,
      0.281285,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '20021',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


