set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '3',
      NULL,
      NULL,
      '1301040',
      116.378751,
      NULL,
      0.565994,
      3,
      '324403',
      0,
      ' 4- 9-1989',
      37.947209,
      NULL,
      NULL,
      NULL,
      0,
      1.763434,
      NULL,
      1.228402,
      1,
      1,
      0,
      1,
      NULL,
      0,
      2.371269,
      NULL,
      NULL,
      1.412089,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.354695,
      3.887436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.827109,
      NULL,
      3.756412,
      1,
      0,
      NULL,
      0.338517,
      NULL,
      NULL,
      NULL,
      3.392289,
      0,
      0.644854,
      2,
      0.252836,
      0.516207,
      NULL,
      0,
      0.338691,
      0.761804,
      0,
      4.556753,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.560132,
      0,
      1,
      1.794626,
      NULL,
      5.844715,
      0.673016,
      1.364041,
      NULL,
      NULL,
      NULL,
      1,
      2.273774,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      5,
      NULL,
      0,
      0,
      0,
      0.142235,
      1.916859,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.213123,
      1.653436,
      1.924223,
      5.207465,
      NULL,
      0.653095,
      6.129524,
      7,
      3.230514,
      4.859560,
      8.895657,
      NULL,
      NULL,
      0,
      2,
      1.525919,
      NULL,
      NULL,
      0.781216,
      1.747725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567767,
      1,
      0,
      NULL,
      0,
      0.279090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.797743,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      0.205060,
      NULL,
      NULL,
      NULL,
      0.458067,
      3.748392,
      1.492358,
      NULL,
      1.629273,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.373843,
      5.885112,
      1.755998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.877188,
      NULL,
      3.419437,
      0,
      NULL,
      NULL,
      1.025363,
      1.906228,
      0,
      0,
      1,
      1.012755,
      1.710440,
      0,
      0.143648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.769583,
      '04320',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0.515939,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


