set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20',
      19,
      10,
      '2140031',
      177.905231,
      1,
      1.651187,
      2,
      '204310',
      2.586975,
      ' 5- 2-2000',
      NULL,
      62.122738,
      0.746736,
      NULL,
      1,
      1,
      2.542043,
      1.363441,
      1,
      0,
      1,
      1,
      2,
      NULL,
      2,
      1.806447,
      1.187139,
      1,
      0.531062,
      1.905984,
      1,
      NULL,
      5,
      1,
      3.033962,
      2,
      4,
      1,
      0.008268,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5.972393,
      0,
      3.280786,
      1,
      1,
      3.545209,
      2,
      1,
      0.757353,
      0,
      NULL,
      0,
      2,
      2.408489,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.196607,
      0,
      3,
      NULL,
      1,
      1.787607,
      1.910281,
      0,
      NULL,
      0,
      1.832355,
      3,
      1.377825,
      NULL,
      1,
      0.382794,
      0,
      NULL,
      0.664177,
      1.889437,
      1.286332,
      NULL,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814820,
      0.276019,
      3.927636,
      1,
      2.958598,
      8,
      NULL,
      0.544293,
      NULL,
      6,
      5.722840,
      2.074534,
      6.447625,
      NULL,
      5,
      1.982758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.726037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.953442,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.140325,
      1.086489,
      5.447637,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.506188,
      1.133730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652922,
      2,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      1,
      2.927354,
      1.890737,
      0.236274,
      1.122173,
      1,
      NULL,
      1.167279,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.869487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.732205,
      '23403',
      '',
      NULL,
      1.309801,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      0.300657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


