set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '214',
      '01',
      NULL,
      NULL,
      '0042241',
      191.994745,
      0,
      NULL,
      3,
      '123300',
      1.588362,
      ' 0- 6-1984',
      55,
      NULL,
      0.980788,
      NULL,
      0.083642,
      1.794171,
      2.777608,
      0.440403,
      NULL,
      1,
      1,
      NULL,
      0.085468,
      0.886945,
      NULL,
      0.017155,
      0,
      0,
      1.589353,
      0,
      5,
      NULL,
      4,
      1,
      1.801679,
      0,
      1.696239,
      NULL,
      0.176138,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.885820,
      NULL,
      NULL,
      1,
      1.171067,
      0,
      2.008266,
      NULL,
      3,
      0.848649,
      1.906135,
      1,
      0,
      0.335279,
      0,
      0.279621,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738559,
      0,
      0,
      0.777232,
      0.444537,
      2,
      0.970587,
      1,
      0,
      0,
      0,
      0,
      3,
      NULL,
      0,
      0.645494,
      0.182072,
      0.328750,
      NULL,
      1,
      0.148826,
      1,
      1.353999,
      0,
      1,
      3.387917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      6,
      3.646810,
      1.956044,
      9.148642,
      8.425907,
      4.397437,
      8,
      4,
      6.768511,
      NULL,
      0.332223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990270,
      0.801177,
      1,
      NULL,
      1.904518,
      1,
      1.309283,
      0.157359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.602967,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.578623,
      3.058406,
      0.453676,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.344774,
      3.832742,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.875001,
      0.801066,
      NULL,
      0,
      NULL,
      0.026003,
      3.709220,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.246813,
      0.777820,
      0,
      1.531758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42224',
      NULL,
      '',
      0.385450,
      '',
      '',
      '',
      0.777632,
      '',
      '',
      '',
      5.409023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


