set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '43',
      5,
      25,
      '0033244',
      NULL,
      2,
      3.524297,
      3,
      '242101',
      5.021815,
      ' 3-19-1992',
      54.142190,
      42.784249,
      1.319888,
      NULL,
      0.705186,
      1,
      1.010126,
      0.753613,
      2,
      NULL,
      1.819605,
      0,
      1,
      NULL,
      2.693950,
      1.500494,
      0.988643,
      1,
      0.729200,
      0.076783,
      2,
      NULL,
      1,
      NULL,
      1.469287,
      0,
      2,
      0,
      3,
      NULL,
      NULL,
      0.101664,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      0,
      1.366062,
      1,
      0.344846,
      NULL,
      2.867812,
      0.189470,
      NULL,
      1.170141,
      1.009888,
      0.841780,
      0.686356,
      1.170832,
      3.871586,
      1,
      1,
      0,
      NULL,
      1,
      4,
      0,
      0,
      0.404881,
      0.276952,
      NULL,
      NULL,
      1.695989,
      NULL,
      NULL,
      NULL,
      1.616315,
      NULL,
      0.811863,
      3,
      1,
      3.440726,
      0.545213,
      0,
      1,
      NULL,
      0,
      0.440147,
      0.026399,
      1,
      1,
      1,
      1.470917,
      1.623049,
      NULL,
      NULL,
      2.226225,
      1.705621,
      4.436128,
      NULL,
      0.255509,
      0.719570,
      1,
      4,
      3.140942,
      5.451385,
      5.327414,
      0.243535,
      2.192959,
      0,
      1.720500,
      3,
      0.643641,
      8.497527,
      NULL,
      3.566943,
      5.375930,
      3.248803,
      4.475934,
      7.484911,
      4.297545,
      1,
      5.136465,
      1,
      NULL,
      NULL,
      3.970196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590265,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848839,
      NULL,
      NULL,
      NULL,
      NULL,
      0.274647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0.758840,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.768278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      3.184619,
      1.232554,
      3,
      NULL,
      3,
      2.839849,
      1,
      1,
      1,
      1,
      NULL,
      1,
      0.874966,
      NULL,
      1.692023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.654356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '40031',
      NULL,
      '',
      0.497998,
      '',
      NULL,
      '',
      1.161190,
      '',
      '',
      NULL,
      3.025296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


