set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '424',
      '01',
      7,
      0,
      NULL,
      222.268150,
      4,
      2.115911,
      3,
      '233140',
      0.120010,
      ' 9-29-2000',
      42.438504,
      42.548883,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      NULL,
      1.999080,
      1.094632,
      1.181819,
      0.049949,
      1,
      5,
      1.603901,
      1.838971,
      NULL,
      1,
      1.324685,
      2,
      0.007832,
      1.750934,
      0,
      3.260502,
      4,
      4,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1.734708,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0.385767,
      NULL,
      NULL,
      1.817142,
      1,
      NULL,
      2.447899,
      0.898474,
      NULL,
      NULL,
      3.334662,
      0,
      2.474325,
      NULL,
      0.280708,
      0,
      NULL,
      0,
      1.731299,
      1,
      NULL,
      1,
      1.899547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.450491,
      1.149728,
      3,
      NULL,
      2,
      NULL,
      NULL,
      0.034557,
      1,
      0,
      NULL,
      3.573963,
      0,
      0,
      1.070868,
      1.454707,
      0.041750,
      NULL,
      1.435592,
      1.619139,
      0.843451,
      1,
      1.577469,
      1,
      3.991760,
      0.253736,
      7,
      NULL,
      NULL,
      5,
      NULL,
      1.607449,
      7,
      NULL,
      3.121021,
      1.752311,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      5.674703,
      NULL,
      4,
      NULL,
      0.844531,
      1.608369,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.539014,
      1,
      1,
      1,
      NULL,
      1,
      1.699506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.376160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.856687,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      7.552293,
      NULL,
      0.506153,
      1,
      5,
      NULL,
      NULL,
      NULL,
      0.956950,
      0.135188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.267398,
      0.009275,
      1,
      1.387281,
      NULL,
      2.991008,
      2.883496,
      1.067580,
      3.325765,
      1.726684,
      NULL,
      0.385642,
      NULL,
      1,
      1.125666,
      1,
      1.754078,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.275638,
      '01220',
      NULL,
      '',
      1.812705,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


