set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '03',
      39,
      21.953094,
      '1010423',
      141,
      5,
      0.080604,
      1,
      '000042',
      2,
      ' 7- 6-1991',
      21.554790,
      49.535675,
      1,
      NULL,
      1.337007,
      0,
      0.697630,
      1,
      0,
      1.958329,
      1,
      0,
      2.095513,
      0.118887,
      4.652072,
      0.747950,
      1.701739,
      NULL,
      0.215315,
      0.310473,
      0.491747,
      1.545819,
      0.943052,
      NULL,
      1.430051,
      0.797924,
      0,
      0,
      NULL,
      1.402444,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686419,
      1,
      4,
      1.199424,
      NULL,
      1.883328,
      NULL,
      3.663126,
      2,
      0.481946,
      NULL,
      1.384246,
      0,
      3,
      2.248484,
      NULL,
      1.083229,
      NULL,
      0.394470,
      NULL,
      1.762938,
      0,
      7.315866,
      0,
      0,
      1,
      1.363090,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.558466,
      1,
      1,
      0.699398,
      1,
      0,
      2.023190,
      0,
      NULL,
      1,
      0,
      0.086777,
      NULL,
      5,
      0.595057,
      NULL,
      1,
      1.876773,
      0,
      NULL,
      1.441732,
      3,
      1,
      0.038275,
      0.932335,
      0.442476,
      4.583891,
      1.056843,
      2.583112,
      NULL,
      NULL,
      1,
      0.690203,
      0.922315,
      4,
      NULL,
      3.916589,
      6,
      5.401187,
      2,
      0,
      6.626737,
      4.590515,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      0,
      1.146479,
      5,
      1.053094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.139808,
      0,
      1,
      0.247980,
      0,
      NULL,
      0.260158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595486,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171701,
      2.817206,
      0.467396,
      NULL,
      NULL,
      NULL,
      3.641466,
      NULL,
      3.792869,
      NULL,
      NULL,
      0,
      0.478393,
      NULL,
      NULL,
      NULL,
      1,
      6.366392,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.243950,
      2.007706,
      1.058741,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.226693,
      1.508626,
      3.560633,
      1.152323,
      0,
      0,
      1,
      1.698206,
      NULL,
      1.297703,
      1.473342,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.416954,
      '24212',
      '',
      NULL,
      1.241639,
      '',
      '',
      NULL,
      1.193954,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


