set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      46,
      43.785004,
      '2214204',
      198,
      2,
      3,
      1,
      '020120',
      5,
      ' 0-23-1974',
      27,
      47,
      NULL,
      NULL,
      NULL,
      0.624104,
      0.419633,
      1,
      1,
      0.319166,
      NULL,
      0,
      1.902267,
      1,
      NULL,
      1,
      0.422854,
      NULL,
      1,
      0,
      5.743447,
      0,
      NULL,
      4,
      3,
      3,
      5.609452,
      0,
      2.145215,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.463671,
      NULL,
      NULL,
      NULL,
      1.004858,
      0,
      1.002799,
      1,
      0,
      NULL,
      2,
      0.842135,
      0,
      NULL,
      2.363511,
      0,
      NULL,
      0.350437,
      0,
      3.558042,
      0.879791,
      1.546004,
      0.125650,
      0,
      1,
      NULL,
      1,
      1,
      1.727110,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.672864,
      NULL,
      1.183689,
      NULL,
      0,
      1.733792,
      2.672699,
      NULL,
      0.967684,
      0,
      1,
      2,
      0,
      2.066924,
      0,
      0.099116,
      1.218292,
      0.208118,
      0,
      NULL,
      NULL,
      2.768393,
      0.798753,
      1.825153,
      NULL,
      1.190389,
      0.140070,
      0.813446,
      5.963038,
      4,
      5.915460,
      5.577121,
      0,
      2,
      6.142832,
      NULL,
      NULL,
      NULL,
      4.236361,
      10,
      NULL,
      7.169592,
      NULL,
      9,
      7.541154,
      2,
      6,
      3,
      0.773956,
      0.112786,
      1.577491,
      1.343480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246584,
      NULL,
      0,
      1,
      1.210522,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.293698,
      1,
      NULL,
      NULL,
      NULL,
      2.532481,
      1,
      1,
      6,
      3.553437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202418,
      3.590865,
      NULL,
      NULL,
      1.077515,
      2,
      2.640971,
      3.583972,
      1,
      NULL,
      3.395376,
      1.672475,
      0.207663,
      0,
      0,
      NULL,
      NULL,
      1.873259,
      0.627942,
      1.671892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '21103',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      1.651629,
      '',
      '',
      '',
      1,
      3.417900,
      1,
      1,
      1.471512,
      0.512933,
      0.708298,
      0.196880,
      3);
commit;
end;
/


