set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '224',
      '1',
      NULL,
      3,
      '1300343',
      178,
      5,
      NULL,
      NULL,
      '114323',
      1.825151,
      ' 1-16-1993',
      56,
      3.225376,
      1,
      NULL,
      0,
      1.082571,
      2,
      NULL,
      0.940967,
      NULL,
      0,
      1.350071,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.795275,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.921177,
      2,
      2.636774,
      1,
      NULL,
      1,
      3.299893,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.476282,
      5,
      0.043811,
      NULL,
      1,
      3,
      NULL,
      1.348142,
      1.091802,
      1,
      NULL,
      1,
      2,
      NULL,
      0.403124,
      2,
      0,
      0.858490,
      2.913818,
      0.564722,
      1.144867,
      2.383598,
      1,
      2,
      NULL,
      1.642136,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.018964,
      1,
      0.701393,
      0,
      4.226508,
      6,
      1.989147,
      1.361978,
      1.656607,
      0.406352,
      0.533462,
      1.947711,
      1.478224,
      1.611651,
      1,
      NULL,
      1.196478,
      0,
      NULL,
      1.923120,
      1,
      1.232139,
      3,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      4.778650,
      0,
      3,
      10,
      1.549257,
      1.191906,
      10.769632,
      1.197597,
      NULL,
      11.436611,
      NULL,
      NULL,
      1.768404,
      NULL,
      NULL,
      0,
      NULL,
      3.300835,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347267,
      0,
      1,
      1,
      0.041537,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.897011,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.418238,
      1.902031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5.422178,
      2.942212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.440735,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      0.124242,
      2,
      1,
      0,
      NULL,
      3,
      2,
      0.335295,
      NULL,
      NULL,
      0.760353,
      0.312085,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.442879,
      '43333',
      '',
      '',
      0.221186,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '',
      3.837790,
      1.146584,
      2,
      0,
      3,
      1.745129,
      0,
      1,
      1);
commit;
end;
/


