set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14202020',
      NULL,
      21,
      '4034213',
      98.774742,
      4,
      0.641830,
      1,
      '424223',
      2.663452,
      NULL,
      44.919371,
      25,
      NULL,
      NULL,
      1.437366,
      0.613287,
      NULL,
      1.878488,
      1.927126,
      1,
      1,
      1,
      1.765914,
      1.444761,
      0.073891,
      1,
      0,
      0,
      1,
      NULL,
      0,
      1.359290,
      NULL,
      NULL,
      4.837483,
      3.364452,
      3.120245,
      0,
      0,
      1,
      1,
      0.357250,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.882511,
      0.872050,
      2,
      2.839288,
      0.226367,
      0,
      1.746627,
      NULL,
      3.999767,
      0,
      NULL,
      0.736847,
      2.028956,
      NULL,
      2.154755,
      NULL,
      0,
      1.643776,
      1.617656,
      0,
      1,
      1,
      6.704769,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.948006,
      0.965643,
      NULL,
      0.756625,
      1.560002,
      0.175920,
      2.940810,
      0,
      0,
      1,
      0.336679,
      0.373508,
      1,
      4,
      1,
      0.683583,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.805558,
      0,
      3,
      3.741411,
      NULL,
      NULL,
      NULL,
      NULL,
      0.224024,
      2.047094,
      0,
      0.475015,
      0,
      NULL,
      10.726071,
      NULL,
      11.385523,
      11.207146,
      NULL,
      NULL,
      6.785475,
      5,
      2.368160,
      3,
      1.493695,
      1.776629,
      NULL,
      0.765710,
      0.908039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0.938491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      4.770090,
      3,
      7,
      NULL,
      3.359458,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.589469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.554423,
      2.489327,
      2.716982,
      NULL,
      NULL,
      NULL,
      1.846398,
      0,
      NULL,
      3,
      1,
      1.668879,
      NULL,
      NULL,
      NULL,
      0.960250,
      0,
      NULL,
      1,
      0.941499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '14143',
      '',
      NULL,
      1.700824,
      '',
      '',
      '',
      0.338593,
      '',
      '',
      NULL,
      5.138032,
      NULL,
      1,
      3.239184,
      0.860067,
      1.021194,
      NULL,
      0.630465,
      3.406551);
commit;
end;
/


