set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '112',
      '20004300',
      15.237471,
      0.414682,
      '1140000',
      NULL,
      NULL,
      3.378761,
      NULL,
      '441101',
      1,
      NULL,
      29.838850,
      14.965036,
      NULL,
      NULL,
      NULL,
      3,
      0.833433,
      1.646457,
      NULL,
      NULL,
      1.852440,
      1.668079,
      2.081906,
      0,
      0.728539,
      NULL,
      0.248199,
      1.495530,
      NULL,
      0,
      NULL,
      0.407417,
      7.079646,
      3.456831,
      1.421598,
      NULL,
      3,
      0,
      2.620065,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.764770,
      6.239771,
      4.473779,
      3.920765,
      1,
      0,
      0.514525,
      0.217315,
      1,
      0,
      0,
      3.637576,
      1,
      3.749206,
      3.373255,
      NULL,
      0.474607,
      0,
      1.796562,
      3,
      5.932687,
      0,
      1.341026,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      0.899790,
      NULL,
      NULL,
      0.864889,
      NULL,
      1.617555,
      2.984533,
      2.160557,
      4,
      NULL,
      1.067654,
      1.077552,
      NULL,
      1,
      1.850487,
      0,
      2,
      1.606098,
      1,
      1.144292,
      0.465653,
      0.869637,
      NULL,
      1,
      3.807181,
      1,
      2.578864,
      3.182065,
      NULL,
      NULL,
      0.821453,
      NULL,
      NULL,
      6,
      2.159077,
      5,
      5.116125,
      NULL,
      0,
      3.004968,
      6,
      NULL,
      1.407475,
      NULL,
      8,
      7.911376,
      6,
      NULL,
      2.826132,
      0,
      2.611227,
      0.369691,
      NULL,
      0.903036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.703803,
      NULL,
      0,
      1,
      1.610723,
      0,
      0.327444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.184469,
      NULL,
      7,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0.009571,
      1,
      NULL,
      NULL,
      NULL,
      4,
      4.332889,
      0.557507,
      6.740912,
      NULL,
      2,
      3,
      0.055130,
      NULL,
      NULL,
      0,
      3.355755,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0.067398,
      1,
      0.666923,
      3,
      1,
      0,
      NULL,
      0.973042,
      0,
      0,
      1.258721,
      0,
      0.922969,
      0,
      0,
      1,
      1.053865,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '40303',
      '',
      '',
      0.505144,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      4.898741,
      1,
      1,
      3,
      NULL,
      0.100582,
      7,
      1);
commit;
end;
/


