set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '14440231',
      NULL,
      NULL,
      '4144400',
      NULL,
      5,
      0,
      2,
      NULL,
      4,
      ' 6-14-1985',
      15,
      39.171437,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.593084,
      0,
      1,
      2.515287,
      1,
      NULL,
      1,
      3,
      2,
      1,
      NULL,
      0.497956,
      NULL,
      3.967051,
      1,
      3.518864,
      2,
      2,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823882,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0.973173,
      0.168460,
      0.122030,
      2.672070,
      1.052351,
      0.851078,
      0.049858,
      0,
      NULL,
      2,
      3.175352,
      1.447486,
      0.228629,
      0,
      NULL,
      0,
      NULL,
      1.576303,
      1.559509,
      0.341240,
      1,
      0,
      1,
      1.056550,
      NULL,
      NULL,
      1.663115,
      NULL,
      NULL,
      0.762283,
      4,
      1.086183,
      2,
      0,
      0,
      0,
      0.214364,
      0,
      1,
      0,
      0.124177,
      0.079636,
      1.543299,
      0,
      NULL,
      1,
      1.028837,
      1,
      NULL,
      1,
      5.708849,
      0.788537,
      1.038820,
      2.937973,
      1.034911,
      0,
      1,
      4.259923,
      2.145171,
      7.868120,
      2.827703,
      NULL,
      3.659470,
      NULL,
      0.813893,
      1.806063,
      NULL,
      4.478058,
      3.694875,
      5.592061,
      NULL,
      6,
      NULL,
      5,
      3,
      0,
      1.358778,
      3,
      1.704892,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.420526,
      NULL,
      1,
      0,
      1,
      0.878332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      1.731212,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.308764,
      2.695935,
      0.082675,
      NULL,
      NULL,
      NULL,
      0.281670,
      NULL,
      NULL,
      5.831229,
      3.055345,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.637370,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.112412,
      3.705530,
      0.950765,
      2.002059,
      2,
      1.688530,
      3.330463,
      2,
      3.718634,
      3,
      NULL,
      1.815208,
      1,
      NULL,
      1.866833,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '00322',
      '',
      '',
      1,
      '',
      '',
      NULL,
      2.942262,
      '03301',
      NULL,
      '',
      5,
      5.350385,
      3.254529,
      3,
      3.242009,
      2.056154,
      2.373103,
      0.770288,
      3);
commit;
end;
/


