set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      60.222843,
      '0031000',
      145,
      5,
      0,
      2,
      '200020',
      2.279336,
      ' 2-23-1988',
      12.443290,
      43.602529,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      6,
      1.063593,
      3.187310,
      0,
      1.582036,
      1.349269,
      2.380808,
      0.144189,
      5.799947,
      0.484519,
      5,
      0.969540,
      6,
      1,
      3,
      0.345082,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.967464,
      0,
      NULL,
      1,
      NULL,
      1.973753,
      3.560470,
      NULL,
      0,
      1,
      3.630274,
      1.095961,
      0,
      1.978728,
      2,
      0.397521,
      1.264173,
      3.338639,
      0,
      3.403678,
      2.711627,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.658113,
      NULL,
      0,
      1,
      2.395812,
      4,
      NULL,
      0,
      1,
      1.689607,
      1.763015,
      0,
      2,
      1,
      1.371100,
      0.154720,
      0.176296,
      0,
      NULL,
      0.935948,
      1,
      2.169332,
      1.949681,
      0,
      NULL,
      NULL,
      0.633872,
      NULL,
      2.896427,
      2,
      NULL,
      2.441465,
      3.986519,
      2.857972,
      0,
      9,
      8.143496,
      NULL,
      7,
      NULL,
      8.360135,
      7.604628,
      3.254154,
      3.701644,
      2.308016,
      NULL,
      5,
      3,
      1.832040,
      0,
      5.052567,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.392970,
      2,
      1,
      NULL,
      NULL,
      0.726093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3.296946,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.618885,
      5.950774,
      0,
      4,
      0,
      2,
      0.528105,
      NULL,
      NULL,
      0.238253,
      1.805090,
      0.465515,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.679220,
      0.523722,
      0.312774,
      1.061371,
      0.898863,
      NULL,
      NULL,
      1,
      NULL,
      0.107276,
      0.708381,
      NULL,
      1,
      0,
      NULL,
      0,
      0.922811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.949647,
      '32202',
      '',
      NULL,
      0,
      '',
      '',
      '',
      3.765702,
      '23131',
      '',
      '',
      4,
      NULL,
      3,
      0.820767,
      NULL,
      0.231790,
      2,
      NULL,
      0);
commit;
end;
/


