set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '02221432',
      9.781211,
      42,
      '1000203',
      NULL,
      3,
      NULL,
      3,
      '304002',
      5.402369,
      NULL,
      5.708511,
      38.710937,
      0.424931,
      NULL,
      0,
      0.655430,
      0.047236,
      1.759195,
      0.280581,
      0,
      NULL,
      1.029314,
      1,
      0.713546,
      7,
      1.194442,
      4,
      NULL,
      1,
      0,
      5,
      NULL,
      NULL,
      NULL,
      3.758390,
      0.597629,
      1,
      0,
      0,
      1.906797,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.241963,
      1,
      NULL,
      2.614481,
      1.723165,
      0,
      2.238823,
      NULL,
      NULL,
      3.819404,
      2,
      1,
      1,
      0.366761,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      1.566650,
      2,
      5,
      NULL,
      0,
      0,
      1.107393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3.112250,
      1.460370,
      0,
      NULL,
      1.523974,
      NULL,
      1.536436,
      0.830492,
      0.385570,
      2.899580,
      0,
      1.450888,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0.767307,
      NULL,
      NULL,
      1,
      2.649599,
      7,
      NULL,
      5,
      4.968109,
      NULL,
      1.610954,
      4,
      NULL,
      5,
      2,
      5,
      8,
      NULL,
      0,
      7,
      NULL,
      1.744148,
      3,
      2.474080,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.291632,
      1,
      0,
      NULL,
      1.076367,
      2.760181,
      0.220165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.208347,
      NULL,
      2,
      1.930340,
      0.177485,
      1.890279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.218667,
      2.184078,
      1.084974,
      NULL,
      NULL,
      NULL,
      NULL,
      5.734228,
      6,
      5,
      NULL,
      0,
      2.305845,
      1,
      NULL,
      NULL,
      1,
      0,
      1.353444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865683,
      2.608977,
      NULL,
      0.985082,
      3.921761,
      0,
      NULL,
      3.795553,
      1.101139,
      1,
      0.365171,
      1,
      1,
      0,
      0.702793,
      0,
      NULL,
      0,
      0.543358,
      1.942261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '22000',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0.526408,
      '3002',
      '',
      '',
      NULL,
      3.319609,
      1,
      3,
      3,
      NULL,
      NULL,
      0,
      NULL);
commit;
end;
/


