set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11232031',
      56.366960,
      54.394077,
      '0123202',
      NULL,
      0,
      NULL,
      3,
      '010232',
      4.925509,
      '10-26-1990',
      28,
      35,
      0,
      NULL,
      1,
      NULL,
      1.997789,
      0.183635,
      1.796845,
      0.512245,
      0,
      1,
      2.067943,
      0,
      6,
      1.661359,
      5.163751,
      NULL,
      1.725504,
      1,
      1.120302,
      5,
      4.539077,
      3,
      4.811832,
      NULL,
      4,
      1,
      2,
      NULL,
      2.113310,
      0.562125,
      NULL,
      NULL,
      1.151620,
      NULL,
      NULL,
      7.019200,
      1,
      3,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1.534471,
      NULL,
      NULL,
      0.719201,
      3.906797,
      0,
      2.478784,
      3.791170,
      0,
      0.312236,
      0,
      0.388812,
      1,
      3.417662,
      0,
      2,
      0,
      1.594382,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.581245,
      4.208490,
      3,
      1.412430,
      1.189569,
      4,
      4,
      1.357160,
      NULL,
      1.045372,
      0,
      1.710519,
      NULL,
      3.496168,
      1,
      1,
      0,
      NULL,
      1.891127,
      NULL,
      1,
      1,
      NULL,
      1.249978,
      2.666678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6,
      0.710228,
      2.800988,
      NULL,
      3,
      4,
      9.641149,
      NULL,
      5,
      NULL,
      3.332828,
      4.846225,
      3,
      5,
      2,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.606178,
      2,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      2.101441,
      3.128756,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.778413,
      0,
      0.948771,
      NULL,
      NULL,
      NULL,
      1,
      3.876231,
      1,
      3.484582,
      5,
      2,
      NULL,
      1.523508,
      NULL,
      NULL,
      1.354601,
      1.217533,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145333,
      0.106631,
      NULL,
      NULL,
      3.160087,
      3.058057,
      1,
      2,
      NULL,
      3.788666,
      3,
      1.051319,
      0,
      1,
      0.290887,
      0.319090,
      0.019974,
      1,
      NULL,
      1.726147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '43203',
      '',
      NULL,
      0.899936,
      '',
      '',
      NULL,
      0,
      '1242',
      NULL,
      '',
      2.521092,
      1,
      3,
      2.086114,
      3,
      NULL,
      2.653912,
      0.523365,
      1.225359);
commit;
end;
/


