set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31110400',
      45,
      26.529041,
      '0103144',
      52,
      NULL,
      2,
      NULL,
      '031410',
      NULL,
      ' 1-25-1986',
      35,
      65,
      NULL,
      NULL,
      1,
      0.234844,
      NULL,
      0,
      NULL,
      1.273911,
      0.733817,
      1,
      0,
      0,
      4,
      0.682873,
      NULL,
      1,
      1.617777,
      1,
      NULL,
      3.599012,
      5,
      NULL,
      4.945939,
      2,
      8.754232,
      1,
      0.840692,
      2.122144,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.345915,
      5,
      7.857266,
      3.367038,
      0,
      0,
      0,
      1.405710,
      3,
      NULL,
      3.110310,
      0.716847,
      NULL,
      3.001848,
      2,
      3.371379,
      NULL,
      1.379384,
      NULL,
      0.456344,
      5.534420,
      1.583268,
      6.144556,
      0,
      2,
      0,
      0.499200,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.926613,
      NULL,
      0.564388,
      1.845357,
      5,
      5,
      2,
      0,
      0,
      NULL,
      NULL,
      0.064466,
      0.924581,
      5.429375,
      0,
      1,
      0,
      0.887770,
      1,
      NULL,
      0.621115,
      1,
      1,
      1,
      NULL,
      1.031698,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424693,
      NULL,
      7,
      0.126531,
      9,
      8.078300,
      5,
      6.405812,
      8.333546,
      1.501535,
      3,
      4.175608,
      1.491501,
      0,
      NULL,
      3,
      NULL,
      1.869017,
      1.864245,
      5.450225,
      1.358674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.856933,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      6,
      NULL,
      0,
      4,
      0.175602,
      NULL,
      NULL,
      1.003925,
      4.950063,
      1.135161,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.704171,
      0.178379,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      0.149731,
      0.667078,
      0,
      1.346376,
      NULL,
      1.111567,
      0.333799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      '',
      1.025322,
      '',
      '',
      '',
      1.139755,
      '1341',
      '',
      '',
      0.131659,
      5,
      0.881590,
      1,
      2.235132,
      NULL,
      NULL,
      3.191168,
      NULL);
commit;
end;
/


