set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '10211343',
      46.661009,
      29,
      '1214143',
      133.353116,
      NULL,
      3,
      NULL,
      '202121',
      0.377679,
      '11-10-1989',
      NULL,
      14.196300,
      0,
      NULL,
      0.527048,
      NULL,
      1.718562,
      0,
      1,
      0,
      1.718800,
      1,
      1.083995,
      1.889360,
      7,
      NULL,
      0.865004,
      0.031541,
      0,
      NULL,
      1,
      NULL,
      3.001176,
      1.507431,
      NULL,
      0.399336,
      3,
      NULL,
      3,
      3,
      3.268803,
      1.224156,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      NULL,
      6.264437,
      1.545854,
      0.418983,
      NULL,
      NULL,
      0,
      3,
      3.155296,
      2,
      0.642877,
      1.758965,
      3,
      NULL,
      1.950272,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      6.797136,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.267916,
      3,
      1,
      1.920145,
      5,
      4.273561,
      1.104857,
      1,
      3,
      0.647249,
      0.680091,
      0,
      NULL,
      4.449831,
      NULL,
      1.269572,
      0.220715,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.705653,
      0.015282,
      0,
      4.896781,
      1.030661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      0.119336,
      0.818347,
      0.468592,
      NULL,
      5,
      10,
      0.814966,
      11.992941,
      4.261133,
      5,
      0.318451,
      2.933457,
      0.609222,
      0.401679,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646475,
      0,
      1,
      NULL,
      1.743968,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.139665,
      NULL,
      6.408730,
      NULL,
      2.293533,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      9,
      1,
      3.479080,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      0.820571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077282,
      3.007516,
      1.845317,
      0,
      2.047504,
      1,
      0.065770,
      3.261911,
      1,
      0,
      2.432215,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0.630818,
      0.679822,
      1.506978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.019093,
      '20240',
      NULL,
      '',
      0.887263,
      '',
      '',
      '',
      NULL,
      '4100',
      '',
      NULL,
      0,
      4.587081,
      0.003434,
      3,
      3,
      0.873274,
      0.974107,
      NULL,
      1.381738);
commit;
end;
/


