set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-7-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4230',
      '10140200',
      78,
      50,
      NULL,
      18.908189,
      2,
      1.011001,
      3,
      '030010',
      5.886451,
      ' 9-10-2001',
      22,
      21.244489,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245851,
      1.051181,
      0,
      NULL,
      0.733922,
      NULL,
      0.480681,
      6,
      0.095989,
      NULL,
      NULL,
      1,
      1.277838,
      0.802359,
      3,
      5,
      NULL,
      5.164924,
      NULL,
      2,
      NULL,
      4.012080,
      3,
      3,
      1.485674,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      1.921392,
      2.958538,
      NULL,
      0.270413,
      1,
      1,
      NULL,
      0.320015,
      3,
      1.135458,
      3,
      0.207054,
      0,
      0.139321,
      NULL,
      NULL,
      2.055740,
      1,
      2,
      NULL,
      1.854102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306437,
      0.790092,
      0,
      0,
      5,
      3,
      2,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      5.155780,
      1,
      1,
      1.809887,
      0.251987,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.277238,
      0.317173,
      4.163930,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      1,
      9.474415,
      11,
      9,
      8,
      7,
      NULL,
      9.259962,
      1.693512,
      1.400205,
      5,
      NULL,
      NULL,
      1.200128,
      NULL,
      NULL,
      0.039467,
      0.252737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1.269711,
      1.881977,
      0.594066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.493380,
      NULL,
      2,
      3.560767,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345568,
      1.560393,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.104204,
      3.625554,
      1.743038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145162,
      1,
      1,
      1,
      2.979937,
      0,
      1.360108,
      2.034900,
      0.839917,
      0.197995,
      2.460904,
      1.751691,
      1.535631,
      1,
      1.875532,
      0,
      1,
      1.580099,
      1.589909,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '04434',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      4,
      5,
      NULL,
      2.051395,
      3,
      1.407460,
      1.601133,
      3,
      1.224435);
commit;
end;
/


