set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1101',
      '20031411',
      NULL,
      78.485975,
      '2114302',
      62.598050,
      3,
      NULL,
      3,
      '330430',
      NULL,
      ' 5-10-1979',
      55.239742,
      61,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.306468,
      1.296803,
      1.521513,
      1.413530,
      1.324567,
      1,
      1,
      NULL,
      1.198055,
      0,
      1,
      0,
      1.771292,
      3,
      3.506268,
      0.624339,
      4,
      1.880991,
      0,
      9.411958,
      NULL,
      2,
      NULL,
      NULL,
      0.863943,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.712248,
      7,
      5.304718,
      NULL,
      NULL,
      1,
      2,
      2.170669,
      1,
      2,
      2,
      1.315178,
      2.438347,
      NULL,
      2,
      1,
      1,
      NULL,
      1.607550,
      0.753579,
      NULL,
      NULL,
      3,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0.952805,
      NULL,
      NULL,
      0,
      2,
      3,
      0,
      1,
      0,
      4.323150,
      0,
      0,
      0.919134,
      1.563629,
      0,
      1.265900,
      NULL,
      0,
      1.141323,
      0.375898,
      1,
      1.380902,
      NULL,
      1.353962,
      1,
      0.725770,
      NULL,
      0,
      1,
      0.056553,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      1.742388,
      1,
      0,
      1.370612,
      9,
      6,
      5.471539,
      0,
      NULL,
      7,
      3.427081,
      1,
      2,
      3,
      1.718878,
      0,
      6.843964,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.187998,
      NULL,
      2,
      0,
      1.377667,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.070343,
      0.845584,
      0.920886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433016,
      1,
      0.968924,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      6,
      4,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.541616,
      0,
      1.895573,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.618181,
      1.422360,
      2,
      1,
      2,
      3.773278,
      NULL,
      0.861473,
      1.752036,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0.813033,
      1,
      0.793609,
      0,
      1.024893,
      0.338372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.217132,
      '11420',
      '',
      '',
      0.639829,
      '',
      '',
      NULL,
      NULL,
      '2012',
      '',
      '',
      2,
      2,
      1.518022,
      3.020510,
      NULL,
      2.975664,
      2,
      0,
      2.686362);
commit;
end;
/


