set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8835390';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3101',
      NULL,
      67.161855,
      32,
      '0221104',
      252.660246,
      NULL,
      0,
      0,
      '131203',
      4,
      '10-12-1998',
      NULL,
      26,
      1.579106,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      1.590947,
      1,
      1.021595,
      1.465176,
      0.349507,
      6,
      1.504880,
      NULL,
      0.973015,
      NULL,
      1.352321,
      NULL,
      1,
      4,
      7,
      5,
      NULL,
      8,
      NULL,
      3.527536,
      1.183785,
      3.749418,
      1.708222,
      NULL,
      NULL,
      1.828101,
      NULL,
      NULL,
      1.271380,
      NULL,
      NULL,
      3.165677,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.051796,
      2,
      0.282924,
      NULL,
      3,
      0.370527,
      0.641018,
      2,
      1.746263,
      1,
      0.779161,
      NULL,
      0.705391,
      4,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.139136,
      NULL,
      1.627196,
      NULL,
      NULL,
      0,
      0.357357,
      1.959356,
      4.797939,
      0.792665,
      1.038186,
      1,
      1.250631,
      1.124743,
      NULL,
      0.179998,
      0.212645,
      1.846056,
      0,
      0.712296,
      NULL,
      0.795059,
      2.861431,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.211897,
      1.468773,
      0,
      7.904220,
      NULL,
      6,
      3.015664,
      3,
      4,
      6,
      7.724377,
      11.742920,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      6,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.207591,
      0.732737,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.502088,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      1.901024,
      NULL,
      1.174659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596132,
      0.711804,
      1,
      0.406995,
      2,
      0,
      0,
      1.272825,
      1,
      2.601063,
      0,
      1.460939,
      0,
      1,
      0,
      NULL,
      1.308340,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '43323',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '2430',
      '',
      NULL,
      5,
      0,
      0,
      0.704027,
      1.014011,
      0.109140,
      3,
      3.555146,
      0.753402);
commit;
end;
/


