set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7226003';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-7-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '020',
      '34',
      51,
      25,
      '4211200',
      85,
      0,
      0,
      2,
      '121010',
      0,
      ' 2-12-1992',
      174,
      17.674025,
      0,
      NULL,
      0,
      0.990001,
      2.953488,
      0.150563,
      1.394882,
      NULL,
      0,
      2.882909,
      NULL,
      0.525053,
      1.860708,
      1,
      0.961419,
      NULL,
      1,
      1,
      1,
      1.484190,
      0.837334,
      1,
      0.855586,
      0.183471,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.913854,
      1.569525,
      1.312420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.173629,
      1.164805,
      1.015615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.067928,
      0.477805,
      0,
      NULL,
      1,
      0.086777,
      0.735816,
      0,
      1,
      0,
      0,
      0.539838,
      0.185668,
      0.252791,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      2,
      0,
      2,
      0.022712,
      NULL,
      0.674163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2.890801,
      5,
      5,
      1.398856,
      NULL,
      1,
      5,
      NULL,
      1.461704,
      2.547195,
      5.711048,
      1.928908,
      0,
      NULL,
      0,
      NULL,
      NULL,
      5.685042,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.271244,
      1,
      0,
      0.287167,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.801180,
      NULL,
      1.238463,
      3.326466,
      NULL,
      1.517496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.762714,
      0,
      NULL,
      NULL,
      NULL,
      6.396212,
      0,
      4.469350,
      NULL,
      3.921334,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.062816,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.913971,
      1.472370,
      1,
      1,
      3,
      0.778501,
      2.325039,
      1.036376,
      3.865444,
      NULL,
      0.898186,
      0.777218,
      0,
      0,
      1,
      0.602736,
      NULL,
      1.723102,
      0.486608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '',
      '',
      '',
      1.279295,
      '23104',
      NULL,
      '',
      1.078575,
      NULL,
      '',
      '',
      4,
      0,
      1,
      NULL,
      2,
      2.100274,
      2.972006,
      1,
      3.556109);
commit;
end;
/


