set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7226003';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '110',
      '31213131',
      25,
      NULL,
      NULL,
      NULL,
      3,
      0.412828,
      2,
      '412111',
      3,
      ' 5-16-1982',
      146.008323,
      47,
      1.128133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.022901,
      0.314621,
      NULL,
      NULL,
      1.853160,
      0.169744,
      1.853610,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.753080,
      NULL,
      1.237138,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906061,
      1.040756,
      0,
      1.194775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.637335,
      0.374391,
      1,
      1,
      0,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      0.859058,
      NULL,
      1.517618,
      3,
      1,
      NULL,
      0,
      1,
      0,
      0.689715,
      5,
      0.651823,
      NULL,
      1.062820,
      4.597889,
      1.446698,
      NULL,
      0,
      4,
      4,
      0.162731,
      3,
      NULL,
      0.545202,
      1,
      5.097986,
      1,
      1,
      0,
      1.415188,
      0.289428,
      NULL,
      NULL,
      4,
      0.891197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175266,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.315975,
      NULL,
      7,
      0.124841,
      1.303015,
      NULL,
      0.437704,
      NULL,
      3,
      1.075154,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0.986769,
      0.852973,
      0.713858,
      1,
      1,
      1,
      1.571507,
      NULL,
      NULL,
      NULL,
      1.846245,
      0.712578,
      1.777378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.068214,
      1.270149,
      NULL,
      1,
      NULL,
      1,
      0.457684,
      0,
      1.269250,
      1,
      1,
      0.068859,
      0.302168,
      0.948242,
      0.693818,
      1,
      1.660512,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '',
      '',
      '',
      0.893978,
      '31043',
      NULL,
      NULL,
      0.987345,
      '',
      '',
      '',
      4,
      3,
      NULL,
      NULL,
      0,
      5.230765,
      1.040534,
      0.655985,
      1);
commit;
end;
/


