set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7226003';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3421',
      '13021030',
      73,
      22.014071,
      '2014131',
      NULL,
      0,
      2,
      3,
      '441003',
      0.954225,
      ' 1- 1-1999',
      164,
      22,
      1,
      NULL,
      NULL,
      NULL,
      3.763543,
      1.083228,
      NULL,
      0,
      1,
      NULL,
      0.651219,
      0,
      NULL,
      1,
      0.026347,
      1.025149,
      1.378285,
      1.425108,
      1,
      1.344945,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502978,
      0.020885,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438477,
      1,
      0.828573,
      0,
      0.612294,
      0.128939,
      1,
      NULL,
      0.108026,
      0.384952,
      1,
      1.922484,
      1.691047,
      0,
      0.711907,
      0,
      0,
      NULL,
      0.835721,
      NULL,
      0.700114,
      3,
      0.768652,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.947011,
      3.856862,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.597573,
      1.753653,
      NULL,
      5,
      5.738411,
      1,
      NULL,
      1.835098,
      0.728401,
      0.528951,
      NULL,
      NULL,
      7,
      0.066916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343476,
      1,
      0,
      0,
      0,
      0,
      0,
      0.859346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096372,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.071080,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.021338,
      1.463655,
      0,
      3.887589,
      NULL,
      1.158612,
      1,
      0,
      NULL,
      1.650831,
      0.676736,
      1,
      0,
      0,
      0.565297,
      1,
      1,
      1,
      0.485506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.035281,
      '',
      '',
      '',
      0,
      '23423',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0.314881,
      2.001346,
      0.937727,
      1,
      2.996895,
      0,
      2,
      0,
      0.630171);
commit;
end;
/


