set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7226003';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0011',
      '24303441',
      31.512054,
      30.744075,
      '2024430',
      212,
      NULL,
      1.151256,
      NULL,
      NULL,
      2.949386,
      ' 2-10-1983',
      70,
      61,
      0,
      NULL,
      0.687405,
      1,
      NULL,
      0,
      1.860150,
      1,
      1,
      3.428989,
      1,
      0.966454,
      1,
      0,
      1,
      0.209397,
      0.129638,
      1.226342,
      1.098893,
      0,
      1,
      1.252170,
      1.261912,
      1.351044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.032015,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.918240,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133127,
      NULL,
      0.423542,
      NULL,
      1,
      1.456319,
      NULL,
      0,
      1.263233,
      1.950612,
      0,
      0,
      0.328323,
      0.681313,
      1,
      0,
      0.748458,
      0,
      0.098919,
      NULL,
      0.602507,
      2.366772,
      NULL,
      0.651640,
      0.121824,
      0,
      1.801636,
      0.546003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.682266,
      1.447674,
      1.075139,
      5,
      5.759501,
      3,
      6.816727,
      5.395988,
      5.662546,
      4.615169,
      1,
      0.073762,
      0,
      0,
      NULL,
      NULL,
      5.525949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1.441632,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303335,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579338,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254047,
      NULL,
      NULL,
      0.901797,
      0.404304,
      1,
      0.781396,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.129254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.765460,
      1.699600,
      1,
      0.368171,
      2.243894,
      0,
      NULL,
      1.880006,
      NULL,
      1,
      1,
      0.398938,
      0.502848,
      0.878894,
      0.320518,
      0,
      NULL,
      NULL,
      1,
      1.986564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '',
      NULL,
      '',
      2.051724,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      5,
      1.221755,
      0.435211,
      3.534377,
      NULL,
      3.341086,
      NULL,
      2,
      1);
commit;
end;
/


